/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Parser;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.parser.PythonParser;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S125", priority=Priority.MAJOR, name="Sections of code should not be \"commented out\"", tags={"unused", "misra"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class CommentedCodeCheck
extends SquidCheck<Grammar>
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "S125";
    public static final String MESSAGE = "Remove this commented out code.";
    private static final Parser<Grammar> parser = PythonParser.create((PythonConfiguration)new PythonConfiguration(Charsets.UTF_8));

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.STRING});
    }

    public void visitNode(AstNode astNode) {
        if (this.isMultilineComment(astNode)) {
            this.visitMultilineComment(astNode.getToken());
        }
    }

    public void visitToken(Token token) {
        List<List<Trivia>> groupedTrivias = this.groupTrivias(token);
        for (List<Trivia> triviaGroup : groupedTrivias) {
            this.checkTriviaGroup(triviaGroup);
        }
    }

    private void visitMultilineComment(Token token) {
        String value = token.getValue();
        int startStringContent = value.endsWith("'''") ? value.indexOf("'''") + 3 : value.indexOf("\"\"\"") + 3;
        int endStringContent = value.length() - 3;
        String text = value.substring(startStringContent, endStringContent);
        if (!this.isEmpty(text = text.trim()) && this.isTextParsedAsCode(text)) {
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, token, new Object[0]);
        }
    }

    private boolean isMultilineComment(AstNode node) {
        String str = node.getTokenValue();
        AstNode expressionStatement = node.getFirstAncestor((AstNodeType)PythonGrammar.EXPRESSION_STMT);
        return (str.endsWith("'''") || str.endsWith("\"\"\"")) && expressionStatement != null && expressionStatement.getNumberOfChildren() == 1;
    }

    private void checkTriviaGroup(List<Trivia> triviaGroup) {
        String text = this.getTextForParsing(triviaGroup);
        if (this.isEmpty(text)) {
            return;
        }
        if (this.isTextParsedAsCode(text)) {
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, triviaGroup.get(0).getToken(), new Object[0]);
        }
    }

    private String getTextForParsing(List<Trivia> triviaGroup) {
        StringBuilder commentTextSB = new StringBuilder();
        for (Trivia trivia : triviaGroup) {
            String value = trivia.getToken().getValue();
            while (value.startsWith("#") || value.startsWith(" #")) {
                value = value.substring(1);
            }
            if (value.startsWith(" ")) {
                value = value.substring(1);
            }
            if (triviaGroup.size() == 1) {
                value = value.trim();
            }
            if (this.isOneWord(value)) continue;
            commentTextSB.append(value);
            commentTextSB.append("\n");
        }
        return commentTextSB.toString();
    }

    private boolean isOneWord(String text) {
        return text.matches("\\s*[\\w/\\-]+\\s*#*\n*");
    }

    private boolean isEmpty(String text) {
        return text.matches("\\s*");
    }

    private boolean isTextParsedAsCode(String text) {
        try {
            AstNode astNode = parser.parse(text);
            List expressions = astNode.getDescendants(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT});
            return astNode.getNumberOfChildren() > 1 && !this.isSimpleExpression(expressions);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSimpleExpression(List<AstNode> expressions) {
        return expressions.size() == 1 && expressions.get(0).getNumberOfChildren() == 1 && expressions.get(0).getFirstChild().is(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR});
    }

    private List<List<Trivia>> groupTrivias(Token token) {
        LinkedList<List<Trivia>> result = new LinkedList<List<Trivia>>();
        List<Trivia> currentGroup = null;
        for (Trivia trivia : token.getTrivia()) {
            currentGroup = this.handleOneLineComment(result, currentGroup, trivia);
        }
        if (currentGroup != null) {
            result.add(currentGroup);
        }
        return result;
    }

    private List<Trivia> handleOneLineComment(List<List<Trivia>> result, @Nullable List<Trivia> currentGroup, Trivia trivia) {
        List<Trivia> newTriviaGroup = currentGroup;
        if (currentGroup == null) {
            newTriviaGroup = new LinkedList<Trivia>();
            newTriviaGroup.add(trivia);
        } else if (currentGroup.get(currentGroup.size() - 1).getToken().getLine() + 1 == trivia.getToken().getLine()) {
            newTriviaGroup.add(trivia);
        } else {
            result.add(currentGroup);
            newTriviaGroup = new LinkedList<Trivia>();
            newTriviaGroup.add(trivia);
        }
        return newTriviaGroup;
    }
}

