/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.NewSymbolsAnalyzer;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1845", priority=Priority.CRITICAL, name="Methods and field names should not differ only by capitalization", tags={"confusing"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class DuplicatedMethodFieldNamesCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1845";
    private static final String MESSAGE = "Rename %s \"%s\" to prevent any misunderstanding/clash with %s \"%s\" defined on line %s";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        List<Token> fieldNames = new NewSymbolsAnalyzer().getClassFields(astNode);
        List<Token> methodNames = this.getFieldNameTokens(astNode);
        this.lookForDuplications(fieldNames, methodNames);
    }

    private List<Token> getFieldNameTokens(AstNode astNode) {
        LinkedList<Token> methodNames = new LinkedList<Token>();
        AstSelect funcDefSelect = astNode.select().children((AstNodeType)PythonGrammar.SUITE).children((AstNodeType)PythonGrammar.STATEMENT).children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.FUNCDEF);
        for (AstNode node : funcDefSelect) {
            methodNames.add(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getToken());
        }
        return methodNames;
    }

    private void lookForDuplications(List<Token> fieldNames, List<Token> methodNames) {
        List<TokenWithTypeInfo> allTokensWithInfo = this.mergeLists(fieldNames, methodNames);
        Collections.sort(allTokensWithInfo, new LineComparator());
        block0: for (int i = 1; i < allTokensWithInfo.size(); ++i) {
            for (int j = i - 1; j >= 0; --j) {
                TokenWithTypeInfo token1 = allTokensWithInfo.get(j);
                TokenWithTypeInfo token2 = allTokensWithInfo.get(i);
                if (!this.differOnlyByCapitalization(token1.getValue(), token2.getValue())) continue;
                this.getContext().createLineViolation((CodeCheck)this, this.getMessage(token1, token2), token2.getLine(), new Object[0]);
                continue block0;
            }
        }
    }

    private boolean differOnlyByCapitalization(String name1, String name2) {
        return name1.equalsIgnoreCase(name2) && !name1.equals(name2);
    }

    private List<TokenWithTypeInfo> mergeLists(List<Token> fieldNames, List<Token> methodNames) {
        LinkedList<TokenWithTypeInfo> allTokensWithInfo = new LinkedList<TokenWithTypeInfo>();
        for (Token token : fieldNames) {
            allTokensWithInfo.add(new TokenWithTypeInfo(token, "field"));
        }
        for (Token token : methodNames) {
            allTokensWithInfo.add(new TokenWithTypeInfo(token, "method"));
        }
        return allTokensWithInfo;
    }

    private String getMessage(TokenWithTypeInfo token1, TokenWithTypeInfo token2) {
        return String.format(MESSAGE, token2.getType(), token2.getValue(), token1.getType(), token1.getValue(), token1.getLine());
    }

    private static class LineComparator
    implements Comparator<TokenWithTypeInfo>,
    Serializable {
        private LineComparator() {
        }

        @Override
        public int compare(TokenWithTypeInfo t1, TokenWithTypeInfo t2) {
            return Integer.compare(t1.getLine(), t2.getLine());
        }
    }

    private static class TokenWithTypeInfo {
        private final Token token;
        private final String type;

        TokenWithTypeInfo(Token token, String type) {
            this.token = token;
            this.type = type;
        }

        String getValue() {
            return this.token.getValue();
        }

        int getLine() {
            return this.token.getLine();
        }

        String getType() {
            return this.type;
        }
    }
}

