/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.NewSymbolsAnalyzer;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1700", priority=Priority.MAJOR, name="A field should not duplicate the name of its containing class", tags={"brain-overload"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class FieldDuplicatesClassNameCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1700";
    private static final String MESSAGE = "Rename field \"%s\"";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        if (CheckUtils.classHasNoInheritance(astNode)) {
            List<Token> allFields = new NewSymbolsAnalyzer().getClassFields(astNode);
            String className = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getTokenValue();
            for (Token name : allFields) {
                if (!className.equalsIgnoreCase(name.getValue())) continue;
                this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE, name.getValue()), name, new Object[0]);
            }
        }
    }
}

