/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.NewSymbolsAnalyzer;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S116", priority=Priority.MINOR, name="Field names should comply with a naming convention", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
@ActivatedByDefault
public class FieldNameCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S116";
    private static final String MESSAGE = "Rename this field \"%s\" to match the regular expression %s.";
    private static final String CONSTANT_PATTERN = "^[_A-Z][A-Z0-9_]*$";
    private static final String DEFAULT = "^[_a-z][_a-z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[_a-z][_a-z0-9]*$")
    public String format = "^[_a-z][_a-z0-9]*$";
    private Pattern pattern = null;
    private Pattern constantPattern = null;

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.constantPattern = Pattern.compile(CONSTANT_PATTERN);
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        if (CheckUtils.classHasNoInheritance(astNode)) {
            List<Token> allFields = new NewSymbolsAnalyzer().getClassFields(astNode);
            this.checkNames(allFields);
        }
    }

    private void checkNames(List<Token> varNames) {
        for (Token name : varNames) {
            if (this.constantPattern.matcher(name.getValue()).matches()) continue;
            this.checkName(name);
        }
    }

    private void checkName(Token token) {
        String name = token.getValue();
        if (!this.pattern.matcher(name).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE, name, this.format), token.getLine(), new Object[0]);
        }
    }
}

