/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="LongIntegerWithLowercaseSuffixUsage", priority=Priority.MINOR, name="Long suffix \"L\" should be upper case", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
@ActivatedByDefault
public class LongIntegerWithLowercaseSuffixUsageCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "LongIntegerWithLowercaseSuffixUsage";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.NUMBER});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.charAt(value.length() - 1) == 'l') {
            this.getContext().createLineViolation((CodeCheck)this, "Replace suffix in long integers from lower case \"l\" to upper case \"L\".", astNode, new Object[0]);
        }
    }
}

