/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.checks.AbstractFunctionNameCheck;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S100", priority=Priority.MINOR, name="Method names should comply with a naming convention", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class MethodNameCheck
extends AbstractFunctionNameCheck {
    public static final String CHECK_KEY = "S100";

    @Override
    public String typeName() {
        return "method";
    }

    @Override
    public boolean shouldCheckFunctionDeclaration(AstNode astNode) {
        return CheckUtils.isMethodDefinition(astNode);
    }
}

