/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1720", priority=Priority.MAJOR, name="Docstrings should be defined")
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class MissingDocstringCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1720";
    private static final Pattern EMPTY_STRING_REGEXP = Pattern.compile("([bruBRU]+)?('\\s*')|(\"\\s*\")|('''\\s*''')|(\"\"\"\\s*\"\"\")");
    private static final String MESSAGE_NO_DOCSTRING = "Add a docstring to this %s.";
    private static final String MESSAGE_EMPTY_DOCSTRING = "The docstring for this %s should not be empty.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FILE_INPUT, PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.FILE_INPUT})) {
            this.visitModule(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            this.visitFuncDef(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
            this.visitClassDef(astNode);
        }
    }

    private void visitModule(AstNode astNode) {
        AstNode firstStatement = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        AstNode firstSimpleStmt = null;
        if (firstStatement != null) {
            firstSimpleStmt = this.firstSimpleStmt(firstStatement);
        }
        this.checkSimpleStmt(astNode, firstSimpleStmt, "module");
    }

    private void visitClassDef(AstNode astNode) {
        this.checkFirstSuite(astNode, "class");
    }

    private void visitFuncDef(AstNode astNode) {
        if (!CheckUtils.isMethodDefinition(astNode)) {
            this.checkFirstSuite(astNode, "function");
        } else {
            this.checkFirstSuite(astNode, "method");
        }
    }

    private void checkFirstSuite(AstNode astNode, String typeName) {
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode firstStatement = suite.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        AstNode firstSimpleStmt = firstStatement == null ? suite.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST}).getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}) : this.firstSimpleStmt(firstStatement);
        this.checkSimpleStmt(astNode, firstSimpleStmt, typeName);
    }

    private void checkSimpleStmt(AstNode astNode, @Nullable AstNode firstSimpleStmt, String typeName) {
        if (firstSimpleStmt != null) {
            this.visitFirstStatement(astNode, firstSimpleStmt, typeName);
        } else {
            this.raiseIssueNoDocstring(astNode, typeName);
        }
    }

    private void raiseIssueNoDocstring(AstNode astNode, String typeName) {
        if (!"method".equals(typeName)) {
            this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE_NO_DOCSTRING, typeName), astNode, new Object[0]);
        }
    }

    private void visitFirstStatement(AstNode astNode, AstNode firstSimpleStmt, String typeName) {
        Token token = firstSimpleStmt.getToken();
        if (token.getType().equals(PythonTokenType.STRING)) {
            if (EMPTY_STRING_REGEXP.matcher(token.getValue()).matches()) {
                this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE_EMPTY_DOCSTRING, typeName), astNode, new Object[0]);
            }
        } else {
            this.raiseIssueNoDocstring(astNode, typeName);
        }
    }

    private AstNode firstSimpleStmt(AstNode statement) {
        AstNode stmtList = statement.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        if (stmtList != null) {
            return stmtList.getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT});
        }
        return null;
    }
}

