/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1578", priority=Priority.MINOR, name="Module names should comply with a naming convention", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class ModuleNameCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1578";
    private static final String DEFAULT = "(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$";
    private static final String MESSAGE = "Rename this module to match this regular expression: \"%s\".";
    @RuleProperty(key="format", defaultValue="(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$")
    public String format = "(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$";
    private Pattern pattern = null;

    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    public void visitFile(@Nullable AstNode astNode) {
        String moduleName;
        String fileName = this.getContext().getFile().getName();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex > 0 && !this.pattern.matcher(moduleName = fileName.substring(0, dotIndex)).matches()) {
            this.getContext().createFileViolation((CodeCheck)this, String.format(MESSAGE, this.format), new Object[0]);
        }
    }
}

