/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S2712", priority=Priority.CRITICAL, name="\"return\" and \"yield\" cannot be used in the same function", tags={"bug"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class ReturnAndYieldInOneFunctionCheck
extends SquidCheck<Grammar> {
    public static final String MESSAGE = "Use only \"return\" or only \"yield\", not both.";
    public static final String CHECK_KEY = "S2712";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        List returnStatements = node.getDescendants(new AstNodeType[]{PythonGrammar.RETURN_STMT});
        List yieldStatements = node.getDescendants(new AstNodeType[]{PythonGrammar.YIELD_STMT});
        if (yieldStatements.isEmpty() || this.allInNestedFunction(yieldStatements, node)) {
            return;
        }
        for (AstNode returnStatement : returnStatements) {
            if (!this.returnHasArgument(returnStatement) || !CheckUtils.insideFunction(returnStatement, node)) continue;
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, node, new Object[0]);
            return;
        }
    }

    private boolean returnHasArgument(AstNode returnStatement) {
        return returnStatement.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}) != null;
    }

    private boolean allInNestedFunction(List<AstNode> statements, AstNode func) {
        for (AstNode statement : statements) {
            if (!CheckUtils.insideFunction(statement, func)) continue;
            return false;
        }
        return true;
    }
}

