/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S104", priority=Priority.MAJOR, name="Files should not have too many lines", tags={"brain-overload"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1h")
@ActivatedByDefault
public class TooManyLinesInFileCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S104";
    private static final int DEFAULT = 1000;
    @RuleProperty(key="maximum", defaultValue="1000")
    public int maximum = 1000;

    public void init() {
        this.subscribeTo(new AstNodeType[]{GenericTokenType.EOF});
    }

    public void visitNode(AstNode astNode) {
        int lines = astNode.getTokenLine();
        if (lines > this.maximum) {
            String message = "File \"{0}\" has {1} lines, which is greater than {2} authorized. Split it into smaller files.";
            this.getContext().createFileViolation((CodeCheck)this, message, new Object[]{this.getContext().getFile().getName(), lines, this.maximum});
        }
    }
}

