/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1142", priority=Priority.MAJOR, name="Functions should not contain too many return statements", tags={"brain-overload"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyReturnsCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1142";
    private static final int DEFAULT_MAX = 3;
    private static final String MESSAGE = "This function has %s returns or yields, which is more than the %s allowed.";
    @RuleProperty(key="max", defaultValue="3")
    public int max = 3;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        AstSelect returnStatements = node.select().descendants(new AstNodeType[]{PythonGrammar.RETURN_STMT, PythonGrammar.YIELD_STMT});
        int returnCount = 0;
        for (AstNode returnStatement : returnStatements) {
            if (!CheckUtils.insideFunction(returnStatement, node)) continue;
            ++returnCount;
        }
        if (returnCount > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE, returnCount, this.max), node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), new Object[0]);
        }
    }
}

