/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.symboltable;

import com.sonar.sslr.api.symboltable.Scope;
import com.sonar.sslr.api.symboltable.ScopeTreeVisitor;
import java.util.Arrays;
import java.util.List;

public class ScopeTreeWalker {
    private final List<ScopeTreeVisitor> visitors;

    public ScopeTreeWalker(ScopeTreeVisitor ... visitors) {
        this.visitors = Arrays.asList(visitors);
    }

    public void walk(Scope scope) {
        this.visit(scope);
        for (Scope nestedScope : scope.getNestedScopes()) {
            this.walk(nestedScope);
        }
        this.leave(scope);
    }

    private void visit(Scope scope) {
        for (ScopeTreeVisitor visitor : this.visitors) {
            visitor.visitScope(scope);
        }
    }

    private void leave(Scope scope) {
        for (ScopeTreeVisitor visitor : this.visitors) {
            visitor.leaveScope(scope);
        }
    }
}

