/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.TokenTypeMatcher;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParsingStackTrace {
    private final StringBuilder stackTrace = new StringBuilder();
    private final ParsingState parsingState;
    private static final int SOURCE_CODE_TOKENS_WINDOW = 30;
    private static final int SOURCE_CODE_LINE_HEADER_WIDTH = 6;

    private ParsingStackTrace(ParsingState parsingState, boolean displaySourceCode) {
        this.parsingState = parsingState;
        if (displaySourceCode) {
            this.displaySourceCode();
        }
        this.displayExpectedToken(parsingState.getOutpostMatcher());
        this.displayButWasToken(parsingState.getOutpostMatcherToken());
    }

    private void displaySourceCode() {
        List<Token> tokens = this.getTokensToDisplayAroundOutpostMatcherToken();
        this.stackTrace.append("------");
        int previousLine = -1;
        StringBuilder lineBuilder = new StringBuilder();
        for (Token token : tokens) {
            int currentLine = token.getLine();
            if (currentLine != previousLine) {
                this.stackTrace.append(lineBuilder.toString() + "\n");
                lineBuilder = new StringBuilder();
                previousLine = currentLine;
                this.displaySourceCodeLineHeader(lineBuilder, token, this.parsingState.getOutpostMatcherTokenLine());
            }
            this.displayToken(lineBuilder, token);
        }
        this.stackTrace.append(lineBuilder.toString() + "\n");
        this.stackTrace.append("------\n");
    }

    private void displayToken(StringBuilder lineBuilder, Token token) {
        while (lineBuilder.length() - 6 < token.getColumn()) {
            lineBuilder.append(" ");
        }
        lineBuilder.append(token.getValue());
    }

    private void displaySourceCodeLineHeader(StringBuilder lineBuilder, Token firstTokenInLine, int parsingErrorLine) {
        if (parsingErrorLine != firstTokenInLine.getLine()) {
            String line = Integer.toString(firstTokenInLine.getLine());
            for (int i = 0; i < 6 - line.length() - 1; ++i) {
                lineBuilder.append(" ");
            }
            lineBuilder.append(line);
            lineBuilder.append(" ");
        } else {
            lineBuilder.append("-->   ");
        }
    }

    private List<Token> getTokensToDisplayAroundOutpostMatcherToken() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int outpostMatcherTokenIndex = this.parsingState.getOutpostMatcherTokenIndex();
        for (int i = outpostMatcherTokenIndex - 30; i <= outpostMatcherTokenIndex + 30; ++i) {
            if (i < 0 || i > this.parsingState.lexerSize - 1) continue;
            tokens.add(this.parsingState.readToken(i));
        }
        return tokens;
    }

    private void displayExpectedToken(Matcher matcher) {
        this.stackTrace.append("Expected : <");
        this.stackTrace.append(matcher.toString());
        if (matcher instanceof TokenTypeMatcher) {
            this.stackTrace.append(" type");
        }
        this.stackTrace.append(">");
    }

    private void displayButWasToken(Token token) {
        this.stackTrace.append(" but was : <");
        if (token != null) {
            this.stackTrace.append(token.getValue());
            this.stackTrace.append(" [" + token.getType() + "]>");
            this.stackTrace.append(" (");
            if (token.isCopyBook()) {
                this.stackTrace.append("copy book ");
            }
            this.stackTrace.append("'" + token.getURI() + "':");
            this.stackTrace.append(" Line " + token.getLine() + " /");
            this.stackTrace.append(" Column " + token.getColumn());
            if (token.isCopyBook()) {
                this.stackTrace.append(" called from file ");
                this.stackTrace.append("'" + token.getCopyBookOriginalFileName() + "':");
                this.stackTrace.append(" Line " + token.getCopyBookOriginalLine());
            }
            this.stackTrace.append(")");
        } else {
            this.stackTrace.append("EOF>");
            if (this.parsingState.lexerSize > 0) {
                Token lastToken = this.parsingState.peekToken(this.parsingState.lexerSize - 1, null);
                this.stackTrace.append(" ('" + lastToken.getURI() + "')");
            }
        }
        this.stackTrace.append("\n");
    }

    public static String generate(ParsingState state) {
        ParsingStackTrace stackTrace = new ParsingStackTrace(state, false);
        return stackTrace.toString();
    }

    public String toString() {
        return this.stackTrace.toString();
    }

    public static String generateFullStackTrace(ParsingState state) {
        if (state.getOutpostMatcher() == null) {
            return "";
        }
        ParsingStackTrace stackTrace = new ParsingStackTrace(state, true);
        return stackTrace.toString();
    }
}

