/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import javax.annotation.Nullable;

public abstract class Matcher {
    public Matcher[] children;

    protected Matcher(Matcher ... children) {
        this.children = children;
    }

    public final boolean isMatching(ParsingState parsingState) {
        return this.matchToIndex(parsingState) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int matchToIndex(ParsingState parsingState) {
        int indexBeforeStarting = parsingState.lexerIndex;
        try {
            this.match(parsingState);
            int n = parsingState.lexerIndex;
            return n;
        }
        catch (BacktrackingEvent re) {
            int n = -1;
            return n;
        }
        finally {
            parsingState.lexerIndex = indexBeforeStarting;
        }
    }

    public abstract AstNode match(ParsingState var1);

    protected MatchResult doMatch(ParsingState parsingState) {
        int startingIndex = parsingState.lexerIndex;
        try {
            AstNode astNode = this.match(parsingState);
            return MatchResult.succeed(parsingState, startingIndex, astNode);
        }
        catch (BacktrackingEvent e) {
            return MatchResult.fail(parsingState, startingIndex);
        }
    }

    protected final void enterEvent(ParsingState parsingState) {
        block4: {
            if (parsingState.parsingEventListeners == null) break block4;
            if (this instanceof RuleMatcher) {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.enterRule((RuleMatcher)this, parsingState);
                }
            } else {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.enterMatcher(this, parsingState);
                }
            }
        }
    }

    protected void exitWithMatchEvent(ParsingState parsingState, @Nullable AstNode astNode) {
        block4: {
            if (parsingState.parsingEventListeners == null) break block4;
            if (this instanceof RuleMatcher) {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithMatchRule((RuleMatcher)this, parsingState, astNode);
                }
            } else {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithMatchMatcher(this, parsingState, astNode);
                }
            }
        }
    }

    protected void exitWithoutMatchEvent(ParsingState parsingState) {
        block4: {
            if (parsingState.parsingEventListeners == null) break block4;
            if (this instanceof RuleMatcher) {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithoutMatchRule((RuleMatcher)this, parsingState);
                }
            } else {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithoutMatchMatcher(this, parsingState);
                }
            }
        }
    }

    protected static final class MatchResult {
        private final AstNode astNode;
        private final int toIndex;
        private static final MatchResult NO_MATCH = new MatchResult(-1, null);

        protected static MatchResult fail(ParsingState parsingState, int startingIndex) {
            parsingState.lexerIndex = startingIndex;
            return NO_MATCH;
        }

        protected static MatchResult succeed(ParsingState parsingState, int startingIndex, @Nullable AstNode astNode) {
            int toIndex = parsingState.lexerIndex;
            if (astNode != null) {
                astNode.setFromIndex(startingIndex);
                astNode.setToIndex(toIndex);
            }
            return new MatchResult(toIndex, astNode);
        }

        private MatchResult(int toIndex, @Nullable AstNode astNode) {
            this.toIndex = toIndex;
            this.astNode = astNode;
        }

        public boolean isMatching() {
            return this.toIndex >= 0;
        }

        public AstNode getAstNode() {
            return this.astNode;
        }

        public int getToIndex() {
            return this.toIndex;
        }
    }
}

