/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.cpd;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.PythonLexer;

public class PythonTokenizer
implements Tokenizer {
    private final Charset charset;

    public PythonTokenizer(Charset charset) {
        this.charset = charset;
    }

    public final void tokenize(SourceCode source, Tokens cpdTokens) {
        Lexer lexer = PythonLexer.create((PythonConfiguration)new PythonConfiguration(this.charset));
        String fileName = source.getFileName();
        List tokens = lexer.lex(new File(fileName));
        for (Token token : tokens) {
            if (token.getType() == PythonTokenType.NEWLINE || token.getType() == PythonTokenType.DEDENT || token.getType() == PythonTokenType.INDENT) continue;
            TokenEntry cpdToken = new TokenEntry(this.getTokenImage(token), fileName, token.getLine());
            cpdTokens.add(cpdToken);
        }
        cpdTokens.add(TokenEntry.getEOF());
    }

    private String getTokenImage(Token token) {
        return token.getValue();
    }
}

