/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.ModuleFileSystem;

@Properties(value={@Property(key="sonar.python.pylint_config", defaultValue="", name="pylint configuration", description="Path to the pylint configuration file to use in pylint analysis. Set to empty to use the default.", global=false, project=true), @Property(key="sonar.python.pylint", defaultValue="", name="pylint executable", description="Path to the pylint executable to use in pylint analysis. Set to empty to use the default one.", global=true, project=false)})
public class PylintConfiguration
implements BatchExtension {
    public static final String PYLINT_CONFIG_KEY = "sonar.python.pylint_config";
    public static final String PYLINT_KEY = "sonar.python.pylint";
    private final Settings conf;

    public PylintConfiguration(Settings conf) {
        this.conf = conf;
    }

    public String getPylintConfigPath(ModuleFileSystem fileSystem) {
        String configPath = this.conf.getString(PYLINT_CONFIG_KEY);
        if (StringUtils.isEmpty((String)configPath)) {
            return null;
        }
        File configFile = new File(configPath);
        if (!configFile.isAbsolute()) {
            File projectRoot = fileSystem.baseDir();
            configFile = new File(projectRoot.getPath(), configPath);
        }
        return configFile.getAbsolutePath();
    }

    public String getPylintPath() {
        return this.conf.getString(PYLINT_KEY);
    }
}

