/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.python.DirectoryScanner;

public abstract class PythonReportSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PythonReportSensor.class);
    protected Settings conf = null;
    protected FileSystem fileSystem;

    public PythonReportSensor(Settings conf, FileSystem fileSystem) {
        this.conf = conf;
        this.fileSystem = fileSystem;
    }

    public boolean shouldExecuteOnProject(Project project) {
        FilePredicates p = this.fileSystem.predicates();
        return this.fileSystem.hasFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
    }

    public void analyse(Project project, SensorContext context) {
        try {
            List<File> reports = this.getReports(this.conf, this.fileSystem.baseDir().getPath(), this.reportPathKey(), this.defaultReportPath());
            this.processReports(context, reports);
        }
        catch (XMLStreamException e) {
            String msg = "Cannot feed the data into sonar, details: '" + e + "'";
            throw new IllegalStateException(msg, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected List<File> getReports(Settings conf, String baseDirPath, String reportPathPropertyKey, String defaultReportPath) {
        String reportPath = conf.getString(reportPathPropertyKey);
        if (reportPath == null) {
            reportPath = defaultReportPath;
        }
        LOG.debug("Using pattern '{}' to find reports", (Object)reportPath);
        DirectoryScanner scanner = new DirectoryScanner(new File(baseDirPath), WildcardPattern.create((String)reportPath));
        return scanner.getIncludedFiles();
    }

    protected void processReports(SensorContext context, List<File> reports) throws XMLStreamException {
    }

    protected String reportPathKey() {
        return "";
    }

    protected String defaultReportPath() {
        return "";
    }
}

