/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.python.PythonAstScanner;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.checks.CheckList;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.indexer.QueryByParent;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;

public final class PythonSquidSensor
implements Sensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final Checks<SquidAstVisitor<Grammar>> checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private SensorContext context;
    private AstScanner<Grammar> scanner;
    private FileSystem fileSystem;
    private ResourcePerspectives resourcePerspectives;

    public PythonSquidSensor(FileLinesContextFactory fileLinesContextFactory, FileSystem fileSystem, ResourcePerspectives perspectives, CheckFactory checkFactory) {
        this.checks = checkFactory.create("python").addAnnotatedChecks((Collection)CheckList.getChecks());
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = fileSystem;
        this.resourcePerspectives = perspectives;
    }

    public boolean shouldExecuteOnProject(Project project) {
        FilePredicates p = this.fileSystem.predicates();
        return this.fileSystem.hasFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
    }

    public void analyse(Project project, SensorContext context) {
        this.context = context;
        ArrayList visitors = Lists.newArrayList((Iterable)this.checks.all());
        visitors.add(new FileLinesVisitor(this.fileLinesContextFactory, this.fileSystem));
        this.scanner = PythonAstScanner.create((PythonConfiguration)this.createConfiguration(), (SquidAstVisitor[])visitors.toArray(new SquidAstVisitor[visitors.size()]));
        FilePredicates p = this.fileSystem.predicates();
        this.scanner.scanFiles((Collection)Lists.newArrayList((Iterable)this.fileSystem.files(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")))));
        Collection squidSourceFiles = this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        this.save(squidSourceFiles);
    }

    private PythonConfiguration createConfiguration() {
        return new PythonConfiguration(this.fileSystem.encoding());
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(new File(squidFile.getKey())));
            this.saveFilesComplexityDistribution(inputFile, squidFile);
            this.saveFunctionsComplexityDistribution(inputFile, squidFile);
            this.saveMeasures(inputFile, squidFile);
            this.saveIssues(inputFile, squidFile);
        }
    }

    private void saveMeasures(InputFile sonarFile, SourceFile squidFile) {
        this.context.saveMeasure(sonarFile, CoreMetrics.FILES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.FILES)));
        this.context.saveMeasure(sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.LINES)));
        this.context.saveMeasure(sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.LINES_OF_CODE)));
        this.context.saveMeasure(sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.STATEMENTS)));
        this.context.saveMeasure(sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.FUNCTIONS)));
        this.context.saveMeasure(sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.CLASSES)));
        this.context.saveMeasure(sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMPLEXITY)));
        this.context.saveMeasure(sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMMENT_LINES)));
    }

    private void saveFunctionsComplexityDistribution(InputFile sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        for (SourceCode squidFunction : squidFunctionsInFile) {
            complexityDistribution.add((Number)squidFunction.getDouble((MetricDef)PythonMetric.COMPLEXITY));
        }
        this.context.saveMeasure(sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveFilesComplexityDistribution(InputFile sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)PythonMetric.COMPLEXITY));
        this.context.saveMeasure(sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveIssues(InputFile sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        for (CheckMessage message : messages) {
            RuleKey ruleKey = this.checks.ruleKey((Object)((SquidAstVisitor)message.getCheck()));
            Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (InputPath)sonarFile);
            if (issuable == null) continue;
            Issue issue = issuable.newIssueBuilder().ruleKey(ruleKey).line(message.getLine()).message(message.getText(Locale.ENGLISH)).build();
            issuable.addIssue(issue);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

