/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.xunit;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.xunit.TestSuite;
import org.sonar.plugins.python.xunit.TestSuiteParser;

@Properties(value={@Property(key="sonar.python.xunit.reportPath", defaultValue="xunit-reports/xunit-result-*.xml", name="Path to xunit report(s)", description="Path to the report of test execution, relative to project's root. Ant patterns are accepted. The reports have to conform to the junitreport XML format.", global=false, project=true), @Property(key="sonar.python.xunit.skipDetails", type=PropertyType.BOOLEAN, defaultValue="true", name="Skip the details when importing the Xunit reports", description="If 'true', provides the test execution statistics only on project level, but makes the import procedure more mature", global=false, project=true)})
public class PythonXUnitSensor
extends PythonReportSensor {
    private static final Logger LOG = LoggerFactory.getLogger(PythonXUnitSensor.class);
    public static final String REPORT_PATH_KEY = "sonar.python.xunit.reportPath";
    public static final String DEFAULT_REPORT_PATH = "xunit-reports/xunit-result-*.xml";
    public static final String SKIP_DETAILS = "sonar.python.xunit.skipDetails";
    private static final double PERCENT_BASE = 100.0;

    public PythonXUnitSensor(Settings conf, FileSystem fileSystem) {
        super(conf, fileSystem);
    }

    @DependsUpon
    public Class dependsUponCoverageSensors() {
        return CoverageExtension.class;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReports(SensorContext context, List<File> reports) throws XMLStreamException {
        if (this.conf.getBoolean(SKIP_DETAILS)) {
            this.simpleMode(context, reports);
        } else {
            this.detailedMode(context, reports);
        }
    }

    private void simpleMode(SensorContext context, List<File> reports) throws XMLStreamException {
        TestSuiteParser parserHandler = new TestSuiteParser();
        StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)parserHandler, false);
        for (File report : reports) {
            parser.parse(report);
        }
        double testsCount = 0.0;
        double testsSkipped = 0.0;
        double testsErrors = 0.0;
        double testsFailures = 0.0;
        double testsTime = 0.0;
        for (TestSuite report : parserHandler.getParsedReports()) {
            testsCount += (double)(report.getTests() - report.getSkipped());
            testsSkipped += (double)report.getSkipped();
            testsErrors += (double)report.getErrors();
            testsFailures += (double)report.getFailures();
            testsTime += (double)report.getTime();
        }
        if (testsCount > 0.0) {
            double testsPassed = testsCount - testsErrors - testsFailures;
            double successDensity = testsPassed * 100.0 / testsCount;
            context.saveMeasure(CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)successDensity)));
            context.saveMeasure(CoreMetrics.TESTS, Double.valueOf(testsCount));
            context.saveMeasure(CoreMetrics.SKIPPED_TESTS, Double.valueOf(testsSkipped));
            context.saveMeasure(CoreMetrics.TEST_ERRORS, Double.valueOf(testsErrors));
            context.saveMeasure(CoreMetrics.TEST_FAILURES, Double.valueOf(testsFailures));
            context.saveMeasure(CoreMetrics.TEST_EXECUTION_TIME, Double.valueOf(testsTime));
        }
    }

    private void detailedMode(SensorContext context, List<File> reports) throws XMLStreamException {
        for (File report : reports) {
            TestSuiteParser parserHandler = new TestSuiteParser();
            StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)parserHandler, false);
            parser.parse(report);
            LOG.info("Processing report '{}'", (Object)report);
            this.processReportDetailed(context, parserHandler.getParsedReports());
        }
    }

    private void processReportDetailed(SensorContext context, Collection<TestSuite> parsedReports) throws XMLStreamException {
        Collection<TestSuite> locatedResources = this.lookupResources(parsedReports);
        for (TestSuite fileReport : locatedResources) {
            InputFile inputFile = fileReport.getInputFile();
            LOG.debug("Saving test execution measures for '{}' under resource '{}'", (Object)fileReport.getKey(), (Object)inputFile.relativePath());
            context.saveMeasure(inputFile, CoreMetrics.SKIPPED_TESTS, Double.valueOf(fileReport.getSkipped()));
            context.saveMeasure(inputFile, CoreMetrics.TESTS, Double.valueOf((double)fileReport.getTests() - (double)fileReport.getSkipped()));
            context.saveMeasure(inputFile, CoreMetrics.TEST_ERRORS, Double.valueOf(fileReport.getErrors()));
            context.saveMeasure(inputFile, CoreMetrics.TEST_FAILURES, Double.valueOf(fileReport.getFailures()));
            context.saveMeasure(inputFile, CoreMetrics.TEST_EXECUTION_TIME, Double.valueOf(fileReport.getTime()));
            double testsRun = (double)fileReport.getTests() - (double)fileReport.getSkipped();
            if (testsRun > 0.0) {
                double passedTests = (double)fileReport.getTests() - (double)fileReport.getErrors() - (double)fileReport.getFailures() - (double)fileReport.getSkipped();
                double successDensity = passedTests * 100.0 / testsRun;
                context.saveMeasure(inputFile, CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)successDensity)));
            }
            context.saveMeasure(inputFile, new Measure(CoreMetrics.TEST_DATA, fileReport.getDetails()));
        }
    }

    private InputFile findResource(String fileKey) {
        return this.findResourceUsingNoseTestsStrategy(fileKey);
    }

    private InputFile findResourceUsingNoseTestsStrategy(String fileKey) {
        String candidateKey2;
        String candidateKey = StringUtils.replace((String)fileKey, (String)".", (String)"/") + ".py";
        InputFile unitTestFile = this.getSonarTestFile(new File(candidateKey));
        if (unitTestFile == null && !(candidateKey2 = StringUtils.replace((String)StringUtils.substringBeforeLast((String)fileKey, (String)"."), (String)".", (String)"/") + ".py").equals(candidateKey)) {
            unitTestFile = this.getSonarTestFile(new File(candidateKey2));
        }
        return unitTestFile;
    }

    private Collection<TestSuite> lookupResources(Collection<TestSuite> testReports) {
        HashMap<String, TestSuite> locatedReports = new HashMap<String, TestSuite>();
        for (TestSuite report : testReports) {
            String fileKey = report.getKey();
            LOG.debug("Trying to find a SonarQube resource for '{}' ...", (Object)fileKey);
            InputFile inputFile = this.findResource(fileKey);
            if (inputFile != null) {
                LOG.debug("... found! The resource is '{}'", (Object)inputFile);
                TestSuite summaryReport = (TestSuite)locatedReports.get(inputFile.absolutePath());
                if (summaryReport != null) {
                    summaryReport.addMeasures(report);
                    continue;
                }
                report.setInputFile(inputFile);
                locatedReports.put(inputFile.absolutePath(), report);
                continue;
            }
            LOG.debug("... cannot find the resource for '{}', drilling down to the details of this test wont be possible", (Object)fileKey);
        }
        return locatedReports.values();
    }

    private InputFile getSonarTestFile(File file) {
        LOG.debug("Using the key '{}' to lookup the resource in SonarQube", (Object)file.getPath());
        return this.fileSystem.inputFile(this.fileSystem.predicates().is(file));
    }
}

