/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    int lengthOption;
    List<EventEvaluator<LoggingEvent>> evaluatorList = null;
    final int MAX_ERROR_COUNT = 4;
    int errorCount = 0;

    @Override
    public void start() {
        String lengthStr = this.getFirstOption();
        if (lengthStr == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(lengthStr = lengthStr.toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(lengthStr)) {
            this.lengthOption = 2;
        } else {
            try {
                this.lengthOption = Integer.parseInt(lengthStr) + 1;
            }
            catch (NumberFormatException nfe) {
                this.addError("Could not parser [" + lengthStr + " as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            int optionListSize = optionList.size();
            for (int i = 1; i < optionListSize; ++i) {
                String evaluatorStr = (String)optionList.get(i);
                Context context = this.getContext();
                Map evaluatorMap = (Map)context.getObject("EVALUATOR_MAP");
                EventEvaluator ee = (EventEvaluator)evaluatorMap.get(evaluatorStr);
                this.addEvaluator(ee);
            }
        }
        super.start();
    }

    private void addEvaluator(EventEvaluator<LoggingEvent> ee) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<LoggingEvent>>();
        }
        this.evaluatorList.add(ee);
    }

    @Override
    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder builder, ThrowableDataPoint tdp) {
    }

    protected void prepareLoggingEvent(LoggingEvent event) {
    }

    @Override
    public String convert(LoggingEvent event) {
        int length;
        StringBuilder buf = new StringBuilder(32);
        ThrowableProxy information = event.getThrowableProxy();
        if (information == null) {
            return "";
        }
        ThrowableDataPoint[] tdpArray = information.getThrowableDataPointArray();
        int n = length = this.lengthOption > tdpArray.length ? tdpArray.length : this.lengthOption;
        if (this.evaluatorList != null) {
            boolean printStack = true;
            for (int i = 0; i < this.evaluatorList.size(); ++i) {
                EventEvaluator<LoggingEvent> ee = this.evaluatorList.get(i);
                try {
                    if (!ee.evaluate(event)) continue;
                    printStack = false;
                    break;
                }
                catch (EvaluationException eex) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + ee.getName() + "]", eex);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + ee.getName() + "].", this, eex);
                    errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus(errorStatus);
                }
            }
            if (!printStack) {
                return "";
            }
        }
        this.prepareLoggingEvent(event);
        buf.append(tdpArray[0]).append(CoreConstants.LINE_SEPARATOR);
        for (int i = 1; i < length; ++i) {
            String string = tdpArray[i].toString();
            buf.append(string);
            this.extraData(buf, tdpArray[i]);
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        return buf.toString();
    }
}

