/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api;

import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstNode {
    protected final AstNodeType type;
    private final String name;
    private final Token token;
    private List<AstNode> children = Collections.EMPTY_LIST;
    private int childIndex = -1;
    private AstNode parent;
    private int fromIndex;
    private int toIndex;

    public AstNode(Token token) {
        this(token.getType(), token.getType().getName(), token);
    }

    public AstNode(AstNodeType type, String name, Token token) {
        this.type = type;
        this.token = token;
        this.name = name;
    }

    public AstNode getParent() {
        return this.parent;
    }

    public void addChild(AstNode child) {
        if (child != null) {
            if (this.children.isEmpty()) {
                this.children = new ArrayList<AstNode>();
            }
            if (child.hasToBeSkippedFromAst()) {
                if (child.hasChildren()) {
                    for (AstNode subChild : child.children) {
                        this.addChildToList(subChild);
                    }
                }
            } else {
                this.addChildToList(child);
            }
        }
    }

    private void addChildToList(AstNode child) {
        this.children.add(child);
        child.childIndex = this.children.size() - 1;
        child.parent = this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<AstNode> getChildren() {
        return this.children;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public AstNode getChild(int index) {
        if (index >= this.getNumberOfChildren()) {
            throw new IllegalStateException("The AstNode '" + this + "' has only " + this.getNumberOfChildren() + " children. Requested child index is wrong : " + index);
        }
        return this.children.get(index);
    }

    public AstNode nextAstNode() {
        AstNode nextSibling = this.nextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        if (this.parent != null) {
            return this.parent.nextAstNode();
        }
        return null;
    }

    public AstNode previousAstNode() {
        AstNode previousSibling = this.previousSibling();
        if (previousSibling != null) {
            return previousSibling;
        }
        if (this.parent != null) {
            return this.parent.previousAstNode();
        }
        return null;
    }

    public AstNode nextSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getNumberOfChildren() > this.childIndex + 1) {
            return this.parent.children.get(this.childIndex + 1);
        }
        return null;
    }

    public AstNode previousSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.childIndex > 0) {
            return this.parent.children.get(this.childIndex - 1);
        }
        return null;
    }

    public String getTokenValue() {
        if (this.token == null) {
            return null;
        }
        return this.token.getValue();
    }

    public String getTokenOriginalValue() {
        if (this.token == null) {
            return null;
        }
        return this.token.getOriginalValue();
    }

    public Token getToken() {
        return this.token;
    }

    public int getTokenLine() {
        return this.token.getLine();
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public String getName() {
        return this.name;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public void setFromIndex(int fromIndex) {
        this.fromIndex = fromIndex;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    public boolean hasToBeSkippedFromAst() {
        if (this.type == null) {
            return true;
        }
        if (AstNodeSkippingPolicy.class.isAssignableFrom(this.type.getClass())) {
            return ((AstNodeSkippingPolicy)this.type).hasToBeSkippedFromAst(this);
        }
        return false;
    }

    public void setToIndex(int toIndex) {
        this.toIndex = toIndex;
    }

    public boolean is(AstNodeType ... types) {
        for (AstNodeType expectedType : types) {
            if (this.type != expectedType) continue;
            return true;
        }
        return false;
    }

    public boolean isNot(AstNodeType ... types) {
        return !this.is(types);
    }

    public AstNode findFirstDirectChild(AstNodeType ... nodeTypes) {
        for (AstNode child : this.children) {
            for (AstNodeType nodeType : nodeTypes) {
                if (child.type != nodeType) continue;
                return child;
            }
        }
        return null;
    }

    public AstNode findFirstChild(AstNodeType ... nodeTypes) {
        for (AstNode child : this.children) {
            for (AstNodeType nodeType : nodeTypes) {
                if (child.type == nodeType) {
                    return child;
                }
                AstNode node = child.findFirstChild(nodeTypes);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public AstNode getFirstChild() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    public List<AstNode> findDirectChildren(AstNodeType ... nodeTypes) {
        ArrayList<AstNode> nodes = new ArrayList<AstNode>();
        for (AstNode child : this.children) {
            for (AstNodeType nodeType : nodeTypes) {
                if (child.type != nodeType) continue;
                nodes.add(child);
            }
        }
        return nodes;
    }

    public List<AstNode> findChildren(AstNodeType ... nodeTypes) {
        ArrayList<AstNode> nodes = new ArrayList<AstNode>();
        this.findChildren(nodes, nodeTypes);
        return nodes;
    }

    private void findChildren(List<AstNode> result, AstNodeType ... nodeTypes) {
        for (AstNodeType nodeType : nodeTypes) {
            if (!this.is(nodeType)) continue;
            result.add(this);
        }
        if (this.hasChildren()) {
            for (AstNode child : this.children) {
                child.findChildren(result, nodeTypes);
            }
        }
    }

    public AstNode getLastChild() {
        return this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    public boolean hasDirectChildren(AstNodeType ... nodeTypes) {
        return this.findFirstDirectChild(nodeTypes) != null;
    }

    public boolean hasChildren(AstNodeType ... nodeTypes) {
        return this.findFirstChild(nodeTypes) != null;
    }

    public boolean hasParents(AstNodeType nodeType) {
        return this.findFirstParent(nodeType) != null;
    }

    public AstNode findFirstParent(AstNodeType nodeType) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.type == nodeType) {
            return this.parent;
        }
        return this.parent.findFirstParent(nodeType);
    }

    public boolean isCopyBookOrGeneratedNode() {
        return this.getToken().isCopyBook() || this.getToken().isGeneratedCode();
    }

    public AstNodeType getType() {
        return this.type;
    }

    public List<Token> getTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.getTokens(tokens);
        return tokens;
    }

    private void getTokens(List<Token> tokens) {
        if (!this.hasChildren()) {
            tokens.add(this.token);
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).getTokens(tokens);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        if (this.token != null) {
            result.append(" token='").append(this.token.getValue()).append("'");
            result.append(" line=").append(this.token.getLine());
            result.append(" column=").append(this.token.getColumn());
            result.append(" uri='").append(this.token.getURI() + "'");
        }
        return result.toString();
    }

    public Token getLastToken() {
        AstNode lastAstNode = this;
        while (lastAstNode.getLastChild() != null) {
            lastAstNode = lastAstNode.getLastChild();
        }
        return lastAstNode.getToken();
    }
}

