/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.Matcher;

public abstract class MemoizedMatcher
extends Matcher {
    public MemoizedMatcher(Matcher ... children) {
        super(children);
    }

    public AstNode match(ParsingState parsingState) {
        this.enterEvent(parsingState);
        AstNode memoizedAstNode = this.getMemoizedAst(parsingState);
        if (memoizedAstNode != null) {
            parsingState.lexerIndex = memoizedAstNode.getToIndex();
            this.exitWithMatchEvent(parsingState, memoizedAstNode);
            return memoizedAstNode;
        }
        int startingIndex = parsingState.lexerIndex;
        try {
            AstNode astNode = this.matchWorker(parsingState);
            if (astNode != null) {
                astNode.setFromIndex(startingIndex);
                astNode.setToIndex(parsingState.lexerIndex);
                this.memoizeAst(parsingState, astNode);
            }
            this.exitWithMatchEvent(parsingState, astNode);
            return astNode;
        }
        catch (BacktrackingEvent re) {
            this.exitWithoutMatchEvent(parsingState);
            throw re;
        }
    }

    protected void memoizeAst(ParsingState parsingState, AstNode astNode) {
        parsingState.memoizeAst(this, astNode);
    }

    protected AstNode getMemoizedAst(ParsingState parsingState) {
        return parsingState.getMemoizedAst(this);
    }

    protected abstract AstNode matchWorker(ParsingState var1);
}

