/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewLineChannel
extends Channel<Lexer> {
    private final LexerState lexerState;

    public NewLineChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    @Override
    public boolean consume(CodeReader code, Lexer output) {
        char ch = (char)code.peek();
        switch (ch) {
            case '(': 
            case '[': 
            case '{': {
                ++this.lexerState.brackets;
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                --this.lexerState.brackets;
                break;
            }
        }
        if (ch == '\\' && NewLineChannel.isNewLine(code.charAt(1))) {
            code.pop();
            this.joinLines(code);
            return true;
        }
        if (NewLineChannel.isNewLine(ch)) {
            if (this.isImplicitLineJoining()) {
                this.joinLines(code);
                return true;
            }
            if (output.getTokens().size() == 0 || output.getTokens().get(output.getTokens().size() - 1).getType() == PythonTokenType.NEWLINE) {
                NewLineChannel.consumeEOL(code);
                return true;
            }
            output.addToken(Token.builder().setLine(code.getLinePosition()).setColumn(code.getColumnPosition()).setURI(output.getURI()).setType(PythonTokenType.NEWLINE).setValueAndOriginalValue("\n").setGeneratedCode(true).build());
            NewLineChannel.consumeEOL(code);
            return true;
        }
        return false;
    }

    private void joinLines(CodeReader code) {
        while (Character.isWhitespace(code.peek())) {
            code.pop();
        }
        this.lexerState.joined = true;
    }

    private static void consumeEOL(CodeReader code) {
        if (code.charAt(0) == '\r' && code.charAt(1) == '\n') {
            code.pop();
            code.pop();
        } else {
            code.pop();
        }
    }

    private static boolean isNewLine(char ch) {
        return ch == '\n' || ch == '\r';
    }

    private boolean isImplicitLineJoining() {
        return this.lexerState.brackets > 0;
    }
}

