/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.toolkit;

import com.google.common.base.Preconditions;
import com.sonar.sslr.impl.Parser;
import java.util.List;
import javax.swing.SwingUtilities;
import org.sonar.colorizer.Tokenizer;
import org.sonar.sslr.internal.toolkit.SourceCodeModel;
import org.sonar.sslr.internal.toolkit.ToolkitPresenter;
import org.sonar.sslr.internal.toolkit.ToolkitViewImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolkit {
    private final Parser<?> parser;
    private final List<Tokenizer> tokenizers;
    private final String title;

    public Toolkit(Parser<?> parser, List<Tokenizer> tokenizers, String title) {
        Preconditions.checkNotNull(parser);
        Preconditions.checkNotNull(tokenizers);
        Preconditions.checkNotNull(title);
        this.parser = parser;
        this.tokenizers = tokenizers;
        this.title = title;
    }

    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceCodeModel model = new SourceCodeModel(Toolkit.this.parser, Toolkit.this.tokenizers);
                ToolkitPresenter presenter = new ToolkitPresenter(model);
                presenter.setView(new ToolkitViewImpl(presenter));
                presenter.run(Toolkit.this.title);
            }
        });
    }
}

