/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final List<Appender<E>> appenderList = new ArrayList<Appender<E>>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock r = this.rwLock.readLock();
    private final Lock w = this.rwLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppender(Appender<E> newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Null argument disallowed");
        }
        this.w.lock();
        try {
            if (!this.appenderList.contains(newAppender)) {
                this.appenderList.add(newAppender);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendLoopOnAppenders(E e) {
        int size = 0;
        this.r.lock();
        try {
            for (Appender<E> appender : this.appenderList) {
                appender.doAppend(e);
                ++size;
            }
        }
        finally {
            this.r.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Appender<E>> iteratorForAppenders() {
        ArrayList<Appender<E>> copy;
        this.r.lock();
        try {
            copy = new ArrayList<Appender<E>>(this.appenderList);
        }
        finally {
            this.r.unlock();
        }
        return copy.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Appender<E> getAppender(String name) {
        if (name == null) {
            return null;
        }
        Appender<E> found = null;
        this.r.lock();
        try {
            for (Appender<E> appender : this.appenderList) {
                if (!name.equals(appender.getName())) continue;
                found = appender;
                break;
            }
        }
        finally {
            this.r.unlock();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        boolean attached = false;
        this.r.lock();
        try {
            for (Appender<E> a : this.appenderList) {
                if (a != appender) continue;
                attached = true;
                break;
            }
        }
        finally {
            this.r.unlock();
        }
        return attached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachAndStopAllAppenders() {
        this.w.lock();
        try {
            for (Appender<E> a : this.appenderList) {
                a.stop();
            }
            this.appenderList.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detachAppender(Appender appender) {
        boolean result;
        if (appender == null) {
            return false;
        }
        this.w.lock();
        try {
            result = this.appenderList.remove(appender);
        }
        finally {
            this.w.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detachAppender(String name) {
        if (name == null) {
            return false;
        }
        boolean removed = false;
        this.w.lock();
        try {
            for (Appender<E> a : this.appenderList) {
                if (!name.equals(a.getName())) continue;
                removed = this.appenderList.remove(a);
                break;
            }
        }
        finally {
            this.w.unlock();
        }
        return removed;
    }
}

