/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.math;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.measures.MetricDef;

public class MeasuresDistribution {
    private final Collection<SourceCode> units;

    public MeasuresDistribution(Collection<SourceCode> units) {
        this.units = units;
    }

    public Map<Integer, Integer> distributeAccordingTo(MetricDef metric, int ... thresholds) {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        for (int threshold : thresholds) {
            result.put(threshold, 0);
        }
        block1: for (SourceCode unit : this.units) {
            for (int index = thresholds.length - 1; index >= 0; --index) {
                if (!(unit.getDouble(metric) >= (double)thresholds[index])) continue;
                result.put(thresholds[index], (Integer)result.get(thresholds[index]) + 1);
                continue block1;
            }
        }
        return result;
    }
}

