/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.measures;

import org.sonar.squidbridge.measures.AbstractnessFormula;
import org.sonar.squidbridge.measures.AggregationFormula;
import org.sonar.squidbridge.measures.CalculatedMetricFormula;
import org.sonar.squidbridge.measures.CommentLinesDensityFormula;
import org.sonar.squidbridge.measures.CommentLinesWithoutHeaderFormula;
import org.sonar.squidbridge.measures.DistanceFormula;
import org.sonar.squidbridge.measures.InstabilityFormula;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.squidbridge.measures.NoAggregationFormula;
import org.sonar.squidbridge.measures.PublicDocumentedApiDensityFormula;
import org.sonar.squidbridge.measures.SumAggregationFormula;

public enum Metric implements MetricDef
{
    PACKAGES,
    CLASSES,
    ANONYMOUS_INNER_CLASSES,
    FILES,
    METHODS,
    CONSTRUCTORS,
    STATEMENTS,
    LINES(false),
    BLANK_LINES(false),
    COMMENT_LINES(false),
    HEADER_COMMENT_LINES(false),
    COMMENTED_OUT_CODE_LINES(false),
    BRANCHES,
    PUBLIC_API,
    PUBLIC_DOC_API,
    ACCESSORS,
    COMMENT_BLANK_LINES(false),
    LINES_OF_CODE(false),
    COMMENT_LINES_WITHOUT_HEADER(new CommentLinesWithoutHeaderFormula()),
    PUBLIC_DOCUMENTED_API_DENSITY(new PublicDocumentedApiDensityFormula()),
    COMMENT_LINES_DENSITY(new CommentLinesDensityFormula()),
    COMPLEXITY,
    INTERFACES,
    ABSTRACT_CLASSES,
    ABSTRACTNESS(new AbstractnessFormula()),
    CA(new NoAggregationFormula()),
    CE(new NoAggregationFormula()),
    INSTABILITY(new InstabilityFormula()),
    DISTANCE(new DistanceFormula()),
    DIT(new NoAggregationFormula()),
    RFC(new NoAggregationFormula()),
    NOC(new NoAggregationFormula()),
    LCOM4(new NoAggregationFormula()),
    LCOM4_BLOCKS;

    private CalculatedMetricFormula formula = null;
    private AggregationFormula aggregationFormula = new SumAggregationFormula();
    private boolean aggregateIfThereIsAlreadyAValue = true;

    private Metric() {
    }

    private Metric(boolean aggregateIfThereIsAlreadyAValue) {
        this.aggregateIfThereIsAlreadyAValue = aggregateIfThereIsAlreadyAValue;
    }

    private Metric(AggregationFormula aggregationFormula) {
        this.aggregationFormula = aggregationFormula;
    }

    private Metric(CalculatedMetricFormula formula) {
        this.formula = formula;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isCalculatedMetric() {
        return this.formula != null;
    }

    @Override
    public boolean aggregateIfThereIsAlreadyAValue() {
        return this.aggregateIfThereIsAlreadyAValue;
    }

    @Override
    public boolean isThereAggregationFormula() {
        return !(this.aggregationFormula instanceof NoAggregationFormula);
    }

    @Override
    public CalculatedMetricFormula getCalculatedMetricFormula() {
        return this.formula;
    }
}

