/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.metrics;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.HashSet;
import java.util.Set;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.measures.MetricDef;

public final class CommentsVisitor<G extends Grammar>
extends SquidAstVisitor<G>
implements AstAndTokenVisitor {
    private Set<Integer> noSonar;
    private Set<Integer> comments;
    private boolean seenFirstToken;
    private final boolean enableNoSonar;
    private final MetricDef commentMetric;
    private final boolean ignoreHeaderComments;

    private CommentsVisitor(CommentsVisitorBuilder<G> builder) {
        this.enableNoSonar = ((CommentsVisitorBuilder)builder).enableNoSonar;
        this.commentMetric = ((CommentsVisitorBuilder)builder).commentMetric;
        this.ignoreHeaderComments = ((CommentsVisitorBuilder)builder).ignoreHeaderComments;
    }

    private void addNoSonar(int line) {
        this.comments.remove(line);
        this.noSonar.add(line);
    }

    private void addCommentLine(int line) {
        if (!this.noSonar.contains(line)) {
            this.comments.add(line);
        }
    }

    @Override
    public void visitFile(AstNode astNode) {
        this.noSonar = new HashSet<Integer>();
        this.comments = new HashSet<Integer>();
        this.seenFirstToken = false;
    }

    @Override
    public void visitToken(Token token) {
        if (!this.ignoreHeaderComments || this.seenFirstToken) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment()) continue;
                String[] commentLines = this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
                int line = trivia.getToken().getLine();
                for (String commentLine : commentLines) {
                    if (this.enableNoSonar && commentLine.contains("NOSONAR")) {
                        this.addNoSonar(line);
                    } else if (this.commentMetric != null && !this.getContext().getCommentAnalyser().isBlank(commentLine)) {
                        this.addCommentLine(line);
                    }
                    ++line;
                }
            }
        }
        this.seenFirstToken = true;
    }

    @Override
    public void leaveFile(AstNode astNode) {
        if (this.enableNoSonar) {
            ((SourceFile)this.getContext().peekSourceCode()).addNoSonarTagLines(this.noSonar);
        }
        if (this.commentMetric != null) {
            this.getContext().peekSourceCode().add(this.commentMetric, this.comments.size());
        }
    }

    public static <G extends Grammar> CommentsVisitorBuilder<G> builder() {
        return new CommentsVisitorBuilder();
    }

    public static final class CommentsVisitorBuilder<G extends Grammar> {
        private boolean enableNoSonar = false;
        private MetricDef commentMetric;
        private boolean ignoreHeaderComments = false;

        private CommentsVisitorBuilder() {
        }

        public CommentsVisitor<G> build() {
            return new CommentsVisitor(this);
        }

        public CommentsVisitorBuilder<G> withNoSonar(boolean enableNoSonar) {
            this.enableNoSonar = enableNoSonar;
            return this;
        }

        public CommentsVisitorBuilder<G> withCommentMetric(MetricDef commentMetric) {
            this.commentMetric = commentMetric;
            return this;
        }

        public CommentsVisitorBuilder<G> withIgnoreHeaderComment(boolean ignoreHeaderComments) {
            this.ignoreHeaderComments = ignoreHeaderComments;
            return this;
        }
    }
}

