/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.log4j;

import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.helpers.Transform;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLayout
extends LayoutBase<LoggingEvent> {
    private final int DEFAULT_SIZE = 256;
    private final int UPPER_LIMIT = 2048;
    private StringBuilder buf = new StringBuilder(256);
    private boolean locationInfo = false;
    private boolean properties = false;

    @Override
    public void start() {
        super.start();
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setProperties(boolean flag) {
        this.properties = flag;
    }

    public boolean getProperties() {
        return this.properties;
    }

    @Override
    public String doLayout(LoggingEvent event) {
        Map<String, String> propertyMap;
        CallerData[] callerDataArray;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuilder(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(event.getLoggerRemoteView().getName());
        this.buf.append("\"\r\n");
        this.buf.append("             timestamp=\"");
        this.buf.append(event.getTimeStamp());
        this.buf.append("\" level=\"");
        this.buf.append(event.getLevel());
        this.buf.append("\" thread=\"");
        this.buf.append(event.getThreadName());
        this.buf.append("\">\r\n");
        this.buf.append("  <log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(this.buf, event.getFormattedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        ThrowableProxy tp = event.getThrowableProxy();
        if (tp != null) {
            ThrowableDataPoint[] tdpArray;
            this.buf.append("  <log4j:throwable><![CDATA[");
            for (ThrowableDataPoint tdp : tdpArray = tp.getThrowableDataPointArray()) {
                this.buf.append(tdp.toString());
                this.buf.append("\r\n");
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo && (callerDataArray = event.getCallerData()) != null && callerDataArray.length > 0) {
            CallerData immediateCallerData = callerDataArray[0];
            this.buf.append("  <log4j:locationInfo class=\"");
            this.buf.append(immediateCallerData.getClassName());
            this.buf.append("\"\r\n");
            this.buf.append("                      method=\"");
            this.buf.append(Transform.escapeTags(immediateCallerData.getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(immediateCallerData.getFileName());
            this.buf.append("\" line=\"");
            this.buf.append(immediateCallerData.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        if (this.getProperties() && (propertyMap = event.getMDCPropertyMap()) != null && propertyMap.size() != 0) {
            Set<Map.Entry<String, String>> entrySet = propertyMap.entrySet();
            this.buf.append("  <log4j:properties>");
            for (Map.Entry<String, String> entry : entrySet) {
                this.buf.append("\r\n    <log4j:data");
                this.buf.append(" name='" + Transform.escapeTags(entry.getKey()) + "'");
                this.buf.append(" value='" + Transform.escapeTags(entry.getValue()) + "'");
                this.buf.append(" />");
            }
            this.buf.append("\r\n  </log4j:properties>");
        }
        this.buf.append("\r\n</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }
}

