/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.Set;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractMagicCheck<G extends Grammar>
extends SquidCheck<G> {
    private AstNodeType[] inclusions;
    private AstNodeType[] exclusions;
    private int inclusionLevel;
    private int exclusionLevel;

    public abstract Set<AstNodeType> getPatterns();

    public abstract Set<AstNodeType> getInclusions();

    public abstract Set<AstNodeType> getExclusions();

    public abstract String getMessage();

    public abstract boolean isExcepted(AstNode var1);

    @Override
    public void visitFile(AstNode fileNode) {
        this.inclusionLevel = 0;
        this.exclusionLevel = 0;
    }

    @Override
    public void init() {
        Set<AstNodeType> patternsSet = this.getPatterns();
        AstNodeType[] patterns = patternsSet.toArray(new AstNodeType[patternsSet.size()]);
        Set<AstNodeType> inclusionsSet = this.getInclusions();
        this.inclusions = inclusionsSet.toArray(new AstNodeType[inclusionsSet.size()]);
        Set<AstNodeType> exclusionsSet = this.getExclusions();
        this.exclusions = exclusionsSet.toArray(new AstNodeType[exclusionsSet.size()]);
        this.subscribeTo(patterns);
        this.subscribeTo(this.inclusions);
        this.subscribeTo(this.exclusions);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(this.inclusions)) {
            ++this.inclusionLevel;
        } else if (astNode.is(this.exclusions)) {
            ++this.exclusionLevel;
        } else if (!(this.inclusions.length != 0 && this.inclusionLevel <= 0 || this.exclusionLevel != 0 || this.isExcepted(astNode))) {
            this.getContext().createLineViolation((CodeCheck)this, this.getMessage(), astNode, new Object[0]);
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(this.inclusions)) {
            --this.inclusionLevel;
        } else if (astNode.is(this.exclusions)) {
            --this.exclusionLevel;
        }
    }
}

