/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.net.URI;
import java.util.List;

public class Token {
    private final TokenType type;
    private final String value;
    private final String originalValue;
    private final int line;
    private final int column;
    private final URI uri;
    private final boolean generatedCode;
    private final List<Trivia> trivia;
    private final boolean copyBook;
    private final int copyBookOriginalLine;
    private final String copyBookOriginalFileName;

    private Token(Builder builder) {
        this.type = builder.type;
        this.value = builder.value;
        this.originalValue = builder.originalValue;
        this.line = builder.line;
        this.column = builder.column;
        this.uri = builder.uri;
        this.generatedCode = builder.generatedCode;
        this.trivia = ImmutableList.copyOf(builder.trivia);
        this.copyBook = builder.copyBook;
        this.copyBookOriginalLine = builder.copyBookOriginalLine;
        this.copyBookOriginalFileName = builder.copyBookOriginalFileName;
    }

    public TokenType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isCopyBook() {
        return this.copyBook;
    }

    public boolean isGeneratedCode() {
        return this.generatedCode;
    }

    public boolean hasTrivia() {
        return !this.trivia.isEmpty();
    }

    public List<Trivia> getTrivia() {
        return this.trivia;
    }

    public int getCopyBookOriginalLine() {
        return this.copyBookOriginalLine;
    }

    public String getCopyBookOriginalFileName() {
        return this.copyBookOriginalFileName;
    }

    public boolean isOnSameLineThan(Token other) {
        return other == null ? false : this.getLine() == other.getLine();
    }

    public String toString() {
        return this.getType() + ": " + this.getValue();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Token token) {
        return new Builder(token);
    }

    public static final class Builder {
        private TokenType type;
        private String value;
        private String originalValue;
        private URI uri;
        private int line = 0;
        private int column = -1;
        private List<Trivia> trivia = ImmutableList.of();
        private boolean generatedCode = false;
        private boolean copyBook = false;
        private int copyBookOriginalLine = -1;
        private String copyBookOriginalFileName = "";

        private Builder() {
        }

        private Builder(Token token) {
            this.type = token.type;
            this.value = token.value;
            this.originalValue = token.originalValue;
            this.uri = token.uri;
            this.line = token.line;
            this.column = token.column;
            this.trivia = token.trivia;
            this.generatedCode = token.generatedCode;
            this.copyBook = token.copyBook;
            this.copyBookOriginalLine = token.copyBookOriginalLine;
            this.copyBookOriginalFileName = token.copyBookOriginalFileName;
        }

        public Builder setType(TokenType type) {
            Preconditions.checkNotNull(type, "type cannot be null");
            this.type = type;
            return this;
        }

        public Builder setValueAndOriginalValue(String valueAndOriginalValue) {
            Preconditions.checkNotNull(valueAndOriginalValue, "valueAndOriginalValue cannot be null");
            this.value = valueAndOriginalValue;
            this.originalValue = valueAndOriginalValue;
            return this;
        }

        public Builder setValueAndOriginalValue(String value, String originalValue) {
            Preconditions.checkNotNull(value, "value cannot be null");
            Preconditions.checkNotNull(originalValue, "originalValue cannot be null");
            this.value = value;
            this.originalValue = originalValue;
            return this;
        }

        public Builder setLine(int line) {
            this.line = line;
            return this;
        }

        public Builder setColumn(int column) {
            this.column = column;
            return this;
        }

        public Builder setURI(URI uri) {
            Preconditions.checkNotNull(uri, "uri cannot be null");
            this.uri = uri;
            return this;
        }

        public Builder setGeneratedCode(boolean generatedCode) {
            this.generatedCode = generatedCode;
            return this;
        }

        public Builder setTrivia(List<Trivia> trivia) {
            Preconditions.checkNotNull(trivia, "trivia can't be null");
            this.trivia = Lists.newArrayList(trivia);
            return this;
        }

        public Builder addTrivia(Trivia trivia) {
            Preconditions.checkNotNull(trivia, "trivia can't be null");
            if (this.trivia.isEmpty()) {
                this.trivia = Lists.newArrayList();
            }
            this.trivia.add(trivia);
            return this;
        }

        public Builder notCopyBook() {
            this.copyBook = false;
            this.copyBookOriginalLine = -1;
            this.copyBookOriginalFileName = "";
            return this;
        }

        public Builder setCopyBook(String copyBookOriginalFileName, int copyBookOriginalLine) {
            Preconditions.checkNotNull(copyBookOriginalFileName, "copyBookOriginalFileName cannot be null");
            this.copyBook = true;
            this.copyBookOriginalFileName = copyBookOriginalFileName;
            this.copyBookOriginalLine = copyBookOriginalLine;
            return this;
        }

        public Token build() {
            Preconditions.checkNotNull(this.type, "type must be set");
            Preconditions.checkNotNull(this.value, "value must be set");
            Preconditions.checkNotNull(this.originalValue, "originalValue must be set");
            Preconditions.checkNotNull(this.uri, "file must be set");
            Preconditions.checkArgument(this.line >= 1, "line must be greater or equal than 1");
            Preconditions.checkArgument(this.column >= 0, "column must be greater or equal than 0");
            return new Token(this);
        }
    }
}

