/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.io.File;
import java.util.Collection;
import org.sonar.python.CharsetAwareVisitor;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.PythonLinesOfCodeVisitor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.parser.PythonParser;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SourceCodeBuilderCallback;
import org.sonar.squidbridge.SourceCodeBuilderVisitor;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.metrics.CommentsVisitor;
import org.sonar.squidbridge.metrics.ComplexityVisitor;
import org.sonar.squidbridge.metrics.CounterVisitor;
import org.sonar.squidbridge.metrics.LinesVisitor;

public final class PythonAstScanner {
    private PythonAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<Grammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<Grammar> scanner = PythonAstScanner.create(new PythonConfiguration(Charsets.UTF_8), visitors);
        scanner.scanFile(file);
        Collection<SourceCode> sources = scanner.getIndex().search(new QueryByType(SourceFile.class));
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<Grammar> create(PythonConfiguration conf, SquidAstVisitor<Grammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("Python Project"));
        Parser<Grammar> parser = PythonParser.create(conf);
        AstScanner.Builder<Grammar> builder = AstScanner.builder(context).setBaseParser(parser);
        builder.withMetrics(PythonMetric.values());
        builder.setFilesMetric(PythonMetric.FILES);
        PythonAstScanner.setCommentAnalyser(builder);
        PythonAstScanner.setClassesAnalyser(builder);
        PythonAstScanner.setMethodAnalyser(builder);
        PythonAstScanner.setMetrics(conf, builder);
        for (SquidAstVisitor<Grammar> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)((Object)visitor)).setCharset(conf.getCharset());
            }
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }

    private static void setMetrics(PythonConfiguration conf, AstScanner.Builder<Grammar> builder) {
        builder.withSquidAstVisitor(new LinesVisitor(PythonMetric.LINES));
        builder.withSquidAstVisitor(new PythonLinesOfCodeVisitor(PythonMetric.LINES_OF_CODE));
        AstNodeType[] complexityAstNodeType = new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.RETURN_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.EXCEPT_CLAUSE, PythonKeyword.IF, PythonKeyword.AND, PythonKeyword.OR};
        builder.withSquidAstVisitor(ComplexityVisitor.builder().setMetricDef(PythonMetric.COMPLEXITY).subscribeTo(complexityAstNodeType).build());
        builder.withSquidAstVisitor(CommentsVisitor.builder().withCommentMetric(PythonMetric.COMMENT_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(PythonMetric.STATEMENTS).subscribeTo(PythonGrammar.STATEMENT).build());
    }

    private static void setMethodAnalyser(AstScanner.Builder<Grammar> builder) {
        builder.withSquidAstVisitor(new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            @Override
            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.getFirstChild(PythonGrammar.FUNCNAME).getFirstChild().getTokenValue();
                SourceFunction function = new SourceFunction(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, PythonGrammar.FUNCDEF));
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(PythonMetric.FUNCTIONS).subscribeTo(PythonGrammar.FUNCDEF).build());
    }

    private static void setClassesAnalyser(AstScanner.Builder<Grammar> builder) {
        builder.withSquidAstVisitor(new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            @Override
            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.getFirstChild(PythonGrammar.CLASSNAME).getFirstChild().getTokenValue();
                SourceClass function = new SourceClass(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, PythonGrammar.CLASSDEF));
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(PythonMetric.CLASSES).subscribeTo(PythonGrammar.CLASSDEF).build());
    }

    private static void setCommentAnalyser(AstScanner.Builder<Grammar> builder) {
        builder.setCommentAnalyser(new CommentAnalyser(){

            @Override
            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String getContents(String comment) {
                return comment.substring(comment.indexOf(35));
            }
        });
    }
}

