/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.toolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.colorizer.KeywordsTokenizer;
import org.sonar.colorizer.Tokenizer;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.parser.PythonParser;
import org.sonar.sslr.toolkit.AbstractConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;
import org.sonar.sslr.toolkit.Validators;

public class PythonConfigurationModel
extends AbstractConfigurationModel {
    private static final Logger LOG = LoggerFactory.getLogger(PythonConfigurationModel.class);
    private static final String CHARSET_PROPERTY_KEY = "sonar.sourceEncoding";
    @VisibleForTesting
    ConfigurationProperty charsetProperty = new ConfigurationProperty("Charset", "sonar.sourceEncoding", PythonConfigurationModel.getPropertyOrDefaultValue("sonar.sourceEncoding", "UTF-8"), Validators.charsetValidator());

    @Override
    public Charset getCharset() {
        return Charset.forName(this.charsetProperty.getValue());
    }

    @Override
    public List<ConfigurationProperty> getProperties() {
        return ImmutableList.of(this.charsetProperty);
    }

    @Override
    public Parser<Grammar> doGetParser() {
        return PythonParser.create(this.getConfiguration());
    }

    @Override
    public List<Tokenizer> doGetTokenizers() {
        return ImmutableList.of(new KeywordsTokenizer("<span class=\"k\">", "</span>", PythonKeyword.keywordValues()));
    }

    @VisibleForTesting
    PythonConfiguration getConfiguration() {
        return new PythonConfiguration(Charset.forName(this.charsetProperty.getValue()));
    }

    @VisibleForTesting
    static String getPropertyOrDefaultValue(String propertyKey, String defaultValue) {
        String propertyValue = System.getProperty(propertyKey);
        if (propertyValue == null) {
            LOG.info("The property \"" + propertyKey + "\" is not set, using the default value \"" + defaultValue + "\".");
            return defaultValue;
        }
        LOG.info("The property \"" + propertyKey + "\" is set, using its value \"" + propertyValue + "\".");
        return propertyValue;
    }
}

