/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.containers.TransientPicoContainer;
import org.sonar.graph.DirectedGraph;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.squidbridge.api.CodeScanner;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeEdge;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;
import org.sonar.squidbridge.api.SourceCodeTreeDecorator;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.api.SquidConfiguration;
import org.sonar.squidbridge.indexer.SquidIndex;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.measures.MetricDef;

public class Squid
implements DirectedGraphAccessor<SourceCode, SourceCodeEdge>,
SourceCodeSearchEngine {
    private MutablePicoContainer pico;
    private final SourceProject project;
    private final SquidIndex squidIndex;
    private DirectedGraph<SourceCode, SourceCodeEdge> graph = new DirectedGraph();
    private final Set<CodeVisitor> externalCodeVisitors = new HashSet<CodeVisitor>();

    public Squid(SquidConfiguration conf) {
        this.pico = new TransientPicoContainer();
        this.pico.addComponent((Object)conf);
        this.project = new SourceProject("Project");
        this.squidIndex = new SquidIndex();
        this.squidIndex.index(this.project);
        this.pico.addComponent((Object)this.squidIndex);
        this.pico.addComponent((Object)this.project);
        this.pico.addComponent(this.graph);
    }

    public Squid() {
        this(new SquidConfiguration());
    }

    public void registerVisitor(CodeVisitor visitor) {
        this.externalCodeVisitors.add(visitor);
    }

    public void registerVisitor(Class<? extends CodeVisitor> visitor) {
        this.addToPicocontainer(visitor);
        this.externalCodeVisitors.add((CodeVisitor)this.pico.getComponent(visitor));
    }

    public <S extends CodeScanner> S register(Class<S> scannerClass) {
        if (this.pico.getComponent(scannerClass) != null) {
            throw new IllegalStateException("The Squid SCANNER '" + scannerClass.getName() + "' can't be registered multiple times.");
        }
        this.addToPicocontainer(scannerClass);
        CodeScanner scanner = (CodeScanner)this.pico.getComponent(scannerClass);
        for (Class clazz : scanner.getVisitorClasses()) {
            this.addToPicocontainer(clazz);
            scanner.accept((CodeVisitor)this.pico.getComponent(clazz));
        }
        for (CodeVisitor externalVisitor : this.externalCodeVisitors) {
            scanner.accept(externalVisitor);
        }
        return (S)scanner;
    }

    @Deprecated
    public SourceProject aggregate() {
        return this.decorateSourceCodeTreeWith(Metric.values());
    }

    public SourceProject decorateSourceCodeTreeWith(MetricDef ... metrics) {
        SourceCodeTreeDecorator decorator = new SourceCodeTreeDecorator(this.project);
        decorator.decorateWith(metrics);
        return this.project;
    }

    public SourceProject getProject() {
        return this.project;
    }

    private void addToPicocontainer(Class<?> classToExpose) {
        if (this.pico.getComponent(classToExpose) == null) {
            this.pico.addComponent(classToExpose);
        }
    }

    @Override
    public SourceCode search(String key) {
        return this.squidIndex.search(key);
    }

    @Override
    public Collection<SourceCode> search(Query ... query) {
        return this.squidIndex.search(query);
    }

    public SourceCodeEdge getEdge(SourceCode from, SourceCode to) {
        return (SourceCodeEdge)this.graph.getEdge((Object)from, (Object)to);
    }

    public Collection<SourceCodeEdge> getIncomingEdges(SourceCode to) {
        return this.graph.getIncomingEdges((Object)to);
    }

    public Collection<SourceCodeEdge> getOutgoingEdges(SourceCode from) {
        return this.graph.getOutgoingEdges((Object)from);
    }

    public Set<SourceCode> getVertices() {
        return this.graph.getVertices();
    }

    public List<SourceCodeEdge> getEdges(Collection<SourceCode> vertices) {
        return this.graph.getEdges(vertices);
    }

    public boolean hasEdge(SourceCode from, SourceCode to) {
        return this.graph.hasEdge((Object)from, (Object)to);
    }

    public void flush() {
        this.graph = null;
        this.pico = null;
    }
}

