/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.annotations;

import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.squidbridge.annotations.ActivatedByDefault;

public class AnnotationBasedProfileBuilder {
    private final RuleFinder ruleFinder;

    public AnnotationBasedProfileBuilder(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile build(String repositoryKey, String profileName, String language, Iterable<Class> annotatedClasses, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create((String)profileName, (String)language);
        for (Class ruleClass : annotatedClasses) {
            this.addRule(ruleClass, profile, repositoryKey, messages);
        }
        return profile;
    }

    private void addRule(Class<?> ruleClass, RulesProfile profile, String repositoryKey, ValidationMessages messages) {
        if (AnnotationUtils.getAnnotation(ruleClass, ActivatedByDefault.class) != null) {
            org.sonar.check.Rule ruleAnnotation = (org.sonar.check.Rule)AnnotationUtils.getAnnotation(ruleClass, org.sonar.check.Rule.class);
            if (ruleAnnotation == null) {
                messages.addWarningText("Class " + ruleClass + " has no Rule annotation");
                return;
            }
            String ruleKey = ruleAnnotation.key();
            Rule rule = this.ruleFinder.findByKey(repositoryKey, ruleKey);
            if (rule == null) {
                messages.addWarningText("Rule not found: [repository=" + repositoryKey + ", key=" + ruleKey + "]");
            } else {
                profile.activateRule(rule, null);
            }
        }
    }
}

