/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.api;

import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.measures.MetricDef;

public class SourceCodeTreeDecorator {
    private final SourceProject project;

    public SourceCodeTreeDecorator(SourceProject project) {
        this.project = project;
    }

    public void decorateWith(MetricDef ... metrics) {
        this.decorateWith(this.project, metrics);
    }

    private void decorateWith(SourceCode sourceCode, MetricDef ... metrics) {
        if (sourceCode.hasChildren()) {
            for (SourceCode child : sourceCode.getChildren()) {
                this.decorateWith(child, metrics);
            }
        }
        for (MetricDef metric : metrics) {
            if (!metric.aggregateIfThereIsAlreadyAValue() && Double.doubleToRawLongBits(sourceCode.getDouble(metric)) != 0L || !sourceCode.hasChildren()) continue;
            for (SourceCode child : sourceCode.getChildren()) {
                if (metric.isCalculatedMetric() || !metric.isThereAggregationFormula()) continue;
                sourceCode.add(metric, child);
            }
        }
    }
}

