/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.api.utils.SonarException;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractCommentRegularExpressionCheck<G extends Grammar>
extends SquidCheck<G>
implements AstAndTokenVisitor {
    private Pattern pattern = null;

    public abstract String getRegularExpression();

    public abstract String getMessage();

    @Override
    public void init() {
        String regularExpression = this.getRegularExpression();
        Preconditions.checkNotNull(regularExpression, "getRegularExpression() should not return null");
        if (!Strings.isNullOrEmpty(regularExpression)) {
            try {
                this.pattern = Pattern.compile(regularExpression, 32);
            }
            catch (RuntimeException e) {
                throw new SonarException("Unable to compile regular expression: " + regularExpression, (Throwable)e);
            }
        }
    }

    @Override
    public void visitToken(Token token) {
        if (this.pattern != null) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment() || !this.pattern.matcher(trivia.getToken().getOriginalValue()).matches()) continue;
                this.getContext().createLineViolation((CodeCheck)this, this.getMessage(), trivia.getToken(), new Object[0]);
            }
        }
    }
}

