/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Set;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractNestedCommentsCheck<G extends Grammar>
extends SquidCheck<G>
implements AstAndTokenVisitor {
    public abstract Set<String> getCommentStartTags();

    @Override
    public void visitToken(Token token) {
        block0: for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            String contents = this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue());
            for (String commentStartTag : this.getCommentStartTags()) {
                if (!contents.contains(commentStartTag)) continue;
                this.getContext().createLineViolation((CodeCheck)this, "This comments contains the nested comment start tag \"{0}\"", trivia.getToken(), commentStartTag);
                continue block0;
            }
        }
    }
}

