/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.Map;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractOneStatementPerLineCheck<G extends Grammar>
extends SquidCheck<G> {
    private final Map<Integer, Integer> statementsPerLine = Maps.newHashMap();

    public abstract AstNodeType getStatementRule();

    public abstract boolean isExcluded(AstNode var1);

    @Override
    public void init() {
        this.subscribeTo(this.getStatementRule());
    }

    @Override
    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
    }

    @Override
    public void visitNode(AstNode statementNode) {
        if (!this.isExcluded(statementNode)) {
            int line = statementNode.getTokenLine();
            if (!this.statementsPerLine.containsKey(line)) {
                this.statementsPerLine.put(line, 0);
            }
            this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
        }
    }

    @Override
    public void leaveFile(AstNode astNode) {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            this.getContext().createLineViolation((CodeCheck)this, "At most one statement is allowed per line, but {0} statements were found on this line.", statementsAtLine.getKey(), statementsAtLine.getValue());
        }
    }
}

