/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.apache.commons.lang.StringUtils;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractSingleLineCommentsSyntaxCheck<G extends Grammar>
extends SquidCheck<G>
implements AstAndTokenVisitor {
    public abstract String getSingleLineCommentSyntaxPrefix();

    @Override
    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment;
            if (!trivia.isComment() || trivia.getToken().getLine() >= token.getLine() || (comment = trivia.getToken().getOriginalValue()).startsWith(this.getSingleLineCommentSyntaxPrefix()) || StringUtils.containsAny(comment, "\r\n")) continue;
            this.getContext().createLineViolation((CodeCheck)this, "This single line comment should use the single line comment syntax \"{0}\"", trivia.getToken(), this.getSingleLineCommentSyntaxPrefix());
        }
    }
}

