/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@Rule(key="InsufficientLineCoverage", name="Lines should have sufficient coverage by unit tests", priority=Priority.MAJOR, tags={"bad-practice"}, description="<p>An issue is created on a file as soon as the line coverage on this file is less than the required threshold. It gives the number of lines to be covered in order to reach the required threshold.</p>")
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearRemediation(coeff="2min", effortToFixDescription="number of lines under the coverage threshold")
public class LineCoverageCheck
extends CommonCheck {
    private static final double DEFAULT_MIN_RATIO = 65.0;
    @RuleProperty(key="minimumLineCoverageRatio", description="The minimum required line coverage ratio.", defaultValue="65.0")
    private double minimumLineCoverageRatio = 65.0;

    @Override
    public void checkResource(Resource resource, DecoratorContext context, RuleKey ruleKey, ResourcePerspectives perspectives) {
        double lineCoverage = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.LINE_COVERAGE), (Double)0.0);
        if (context.getMeasure(CoreMetrics.LINE_COVERAGE) != null && lineCoverage < this.minimumLineCoverageRatio) {
            double uncoveredLines = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.UNCOVERED_LINES), (Double)0.0);
            double linesToCover = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.LINES_TO_COVER), (Double)0.0);
            double linesToCoverToReachThreshold = Math.ceil(linesToCover * this.minimumLineCoverageRatio / 100.0 - (linesToCover - uncoveredLines));
            this.createIssue(resource, ruleKey, linesToCoverToReachThreshold, perspectives);
        }
    }

    private void createIssue(Resource resource, RuleKey ruleKey, double linesToCoverToReachThreshold, ResourcePerspectives perspectives) {
        this.createIssue(resource, perspectives, ruleKey, linesToCoverToReachThreshold, (int)linesToCoverToReachThreshold + " more lines of code need to be covered by unit tests to reach the minimum threshold of " + this.minimumLineCoverageRatio + "% lines coverage.");
    }

    public void setMinimumLineCoverageRatio(int threshold) {
        this.minimumLineCoverageRatio = threshold;
    }
}

