/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.rules;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import org.sonar.api.server.rule.RulesDefinition;

@Beta
public class ExternalDescriptionLoader {
    private final String resourceBasePath;

    public ExternalDescriptionLoader(RulesDefinition.NewRepository repository, String resourceBasePath) {
        this.resourceBasePath = resourceBasePath;
    }

    public static void loadHtmlDescriptions(RulesDefinition.NewRepository repository, String languageKey) {
        ExternalDescriptionLoader loader = new ExternalDescriptionLoader(repository, languageKey);
        for (RulesDefinition.NewRule newRule : repository.rules()) {
            loader.addHtmlDescription(newRule);
        }
    }

    public void addHtmlDescription(RulesDefinition.NewRule rule) {
        URL resource = ExternalDescriptionLoader.class.getResource(this.resourceBasePath + "/" + rule.key() + ".html");
        if (resource != null) {
            this.addHtmlDescription(rule, resource);
        }
    }

    @VisibleForTesting
    void addHtmlDescription(RulesDefinition.NewRule rule, URL resource) {
        try {
            rule.setHtmlDescription(Resources.toString(resource, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + resource, e);
        }
    }
}

