/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.rules;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.sonar.api.server.rule.RulesDefinition;

@Beta
public class PropertyFileLoader {
    private PropertyFileLoader() {
    }

    public static void loadNames(RulesDefinition.NewRepository repository, String resourceAbsolutePath) {
        InputStream stream = PropertyFileLoader.class.getResourceAsStream(resourceAbsolutePath);
        if (stream == null) {
            throw new IllegalArgumentException("Cound not find resource: " + resourceAbsolutePath);
        }
        PropertyFileLoader.loadNames(repository, stream);
    }

    public static void loadNames(RulesDefinition.NewRepository repository, InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read names from properties", e);
        }
        for (RulesDefinition.NewRule rule : repository.rules()) {
            String baseKey = "rule." + repository.key() + "." + rule.key();
            String nameKey = baseKey + ".name";
            String ruleName = properties.getProperty(nameKey);
            if (ruleName != null) {
                rule.setName(ruleName);
            }
            for (RulesDefinition.NewParam param : rule.params()) {
                String paramDescriptionKey = baseKey + ".param." + param.key();
                String paramDescription = properties.getProperty(paramDescriptionKey);
                if (paramDescription == null) continue;
                param.setDescription(paramDescription);
            }
        }
    }
}

