/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.ParseNode;

public class MachineStack {
    private final MachineStack parent;
    private MachineStack child;
    private final List<ParseNode> subNodes;
    private int address;
    private int index;
    private boolean ignoreErrors;
    private Matcher matcher;
    private int leftRecursion;
    private int calledAddress;

    public MachineStack() {
        this.parent = null;
        this.subNodes = Collections.emptyList();
        this.index = -1;
    }

    private MachineStack(MachineStack parent) {
        this.parent = parent;
        this.subNodes = Lists.newArrayList();
    }

    public MachineStack parent() {
        return this.parent;
    }

    public MachineStack getOrCreateChild() {
        if (this.child == null) {
            this.child = new MachineStack(this);
        }
        return this.child;
    }

    public boolean isReturn() {
        return this.matcher != null;
    }

    public boolean isEmpty() {
        return this.index == -1;
    }

    public int address() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int index() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public void setMatcher(@Nullable Matcher matcher) {
        this.matcher = matcher;
    }

    public int leftRecursion() {
        return this.leftRecursion;
    }

    public void setLeftRecursion(int leftRecursion) {
        this.leftRecursion = leftRecursion;
    }

    public int calledAddress() {
        return this.calledAddress;
    }

    public void setCalledAddress(int calledAddress) {
        this.calledAddress = calledAddress;
    }

    public List<ParseNode> subNodes() {
        return this.subNodes;
    }
}

