/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux.server;

import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerTransport;

public interface ServerSession
extends Session {
    public void addExtension(Extension var1);

    public void removeExtension(Extension var1);

    public List<Extension> getExtensions();

    public void addListener(ServerSessionListener var1);

    public void removeListener(ServerSessionListener var1);

    public ServerTransport getServerTransport();

    public boolean isLocalSession();

    public LocalSession getLocalSession();

    public void deliver(Session var1, ServerMessage.Mutable var2, Promise<Boolean> var3);

    public void deliver(Session var1, String var2, Object var3, Promise<Boolean> var4);

    public Set<ServerChannel> getSubscriptions();

    public String getUserAgent();

    public long getInterval();

    public void setInterval(long var1);

    public long getTimeout();

    public void setTimeout(long var1);

    public long getMaxInterval();

    public void setMaxInterval(long var1);

    public boolean isMetaConnectDeliveryOnly();

    public void setMetaConnectDeliveryOnly(boolean var1);

    public boolean isBroadcastToPublisher();

    public void setBroadcastToPublisher(boolean var1);

    public static interface Extension {
        default public void incoming(ServerSession session, ServerMessage.Mutable message, Promise<Boolean> promise) {
            promise.succeed((Object)(message.isMeta() ? this.rcvMeta(session, message) : this.rcv(session, message)));
        }

        default public boolean rcv(ServerSession session, ServerMessage.Mutable message) {
            return true;
        }

        default public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
            return true;
        }

        default public void outgoing(ServerSession sender, ServerSession session, ServerMessage.Mutable message, Promise<ServerMessage.Mutable> promise) {
            if (message.isMeta()) {
                promise.succeed((Object)(this.sendMeta(sender, session, message) ? message : null));
            } else {
                ServerMessage result = this.send(sender, session, message);
                if (result instanceof ServerMessage.Mutable) {
                    promise.succeed((Object)((ServerMessage.Mutable)result));
                } else if (result == null) {
                    promise.succeed(null);
                } else {
                    promise.fail((Throwable)new IllegalArgumentException());
                }
            }
        }

        default public ServerMessage send(ServerSession sender, ServerSession session, ServerMessage message) {
            return message;
        }

        default public boolean sendMeta(ServerSession sender, ServerSession session, ServerMessage.Mutable message) {
            return true;
        }
    }

    public static interface HeartBeatListener
    extends ServerSessionListener {
        default public void onSuspended(ServerSession session, ServerMessage message, long timeout) {
        }

        default public void onResumed(ServerSession session, ServerMessage message, boolean timeout) {
        }
    }

    @Deprecated
    public static interface MaxQueueListener
    extends QueueMaxedListener {
        @Override
        default public boolean queueMaxed(ServerSession session, Queue<ServerMessage> queue, ServerSession sender, ServerMessage message) {
            return this.queueMaxed(session, queue, sender, (Message)message);
        }

        public boolean queueMaxed(ServerSession var1, Queue<ServerMessage> var2, ServerSession var3, Message var4);
    }

    public static interface QueueMaxedListener
    extends ServerSessionListener {
        public boolean queueMaxed(ServerSession var1, Queue<ServerMessage> var2, ServerSession var3, ServerMessage var4);
    }

    public static interface DeQueueListener
    extends ServerSessionListener {
        default public void deQueue(ServerSession session, Queue<ServerMessage> queue, List<ServerMessage.Mutable> replies) {
            this.deQueue(session, queue);
        }

        public void deQueue(ServerSession var1, Queue<ServerMessage> var2);
    }

    public static interface QueueListener
    extends ServerSessionListener {
        public void queued(ServerSession var1, ServerMessage var2);
    }

    public static interface MessageListener
    extends ServerSessionListener {
        default public void onMessage(ServerSession session, ServerSession sender, ServerMessage message, Promise<Boolean> promise) {
            promise.succeed((Object)this.onMessage(session, sender, message));
        }

        default public boolean onMessage(ServerSession session, ServerSession sender, ServerMessage message) {
            return true;
        }
    }

    @Deprecated
    public static interface RemoveListener
    extends RemovedListener {
        @Override
        default public void removed(ServerSession session, ServerMessage message, boolean timeout) {
            this.removed(session, timeout);
        }

        public void removed(ServerSession var1, boolean var2);
    }

    public static interface RemovedListener
    extends ServerSessionListener {
        public void removed(ServerSession var1, ServerMessage var2, boolean var3);
    }

    @Deprecated
    public static interface AddListener
    extends AddedListener {
        @Override
        default public void added(ServerSession session, ServerMessage message) {
            this.added(session);
        }

        public void added(ServerSession var1);
    }

    public static interface AddedListener
    extends ServerSessionListener {
        public void added(ServerSession var1, ServerMessage var2);
    }

    public static interface ServerSessionListener
    extends Bayeux.BayeuxListener {
    }
}

