/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.delegate;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.language.AstPrinter;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.Request;
import org.dotwebstack.graphql.orchestrate.Result;
import org.dotwebstack.graphql.orchestrate.delegate.ArgsFromEnvFunction;
import org.dotwebstack.graphql.orchestrate.delegate.DelegateException;
import org.dotwebstack.graphql.orchestrate.delegate.Delegator;
import org.dotwebstack.graphql.orchestrate.schema.Subschema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDelegator
implements Delegator {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDelegator.class);
    @NonNull
    private final Subschema subschema;
    @NonNull
    private final String fieldName;
    @NonNull
    private final ArgsFromEnvFunction argsFromEnv;

    @Override
    public CompletableFuture<Object> delegate(DataFetchingEnvironment environment) {
        Field rootField = environment.getField().transform(builder -> builder.name(this.fieldName).arguments((List)this.argsFromEnv.apply(environment)));
        Request originalRequest = Request.newRequest().selectionSet(new SelectionSet(List.of(rootField))).variableDefinitions(environment.getOperationDefinition().getVariableDefinitions()).variables(environment.getVariables()).build();
        return Optional.ofNullable(this.subschema.getTransform()).map(transform -> transform.transform(originalRequest, this::delegateRequest)).orElseGet(() -> this.delegateRequest(originalRequest)).thenApply(result -> result.getData().get(this.fieldName));
    }

    private CompletableFuture<Result> delegateRequest(Request request) {
        OperationDefinition operationDefinition = OperationDefinition.newOperationDefinition().operation(OperationDefinition.Operation.QUERY).selectionSet(request.getSelectionSet()).variableDefinitions(request.getVariableDefinitions()).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(AstPrinter.printAst((Node)operationDefinition)).variables(request.getVariables()).build();
        return this.subschema.execute(executionInput).thenApply(this::mapResult);
    }

    private Result mapResult(ExecutionResult executionResult) {
        List errors = executionResult.getErrors();
        if (!errors.isEmpty()) {
            LOG.error("GraphQL query returned errors:\n{}", (Object)errors.stream().map(GraphQLError::getMessage).map("- "::concat).collect(Collectors.joining("\n")));
            throw new DelegateException(errors);
        }
        return Result.newResult().data((Map)executionResult.getData()).build();
    }

    @Generated
    private static ArgsFromEnvFunction $default$argsFromEnv() {
        return environment -> List.of();
    }

    @Generated
    SimpleDelegator(@NonNull Subschema subschema, @NonNull String fieldName, @NonNull ArgsFromEnvFunction argsFromEnv) {
        if (subschema == null) {
            throw new NullPointerException("subschema is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (argsFromEnv == null) {
            throw new NullPointerException("argsFromEnv is marked non-null but is null");
        }
        this.subschema = subschema;
        this.fieldName = fieldName;
        this.argsFromEnv = argsFromEnv;
    }

    @Generated
    public static SimpleDelegatorBuilder newDelegator() {
        return new SimpleDelegatorBuilder();
    }

    @Generated
    public static class SimpleDelegatorBuilder {
        @Generated
        private Subschema subschema;
        @Generated
        private String fieldName;
        @Generated
        private boolean argsFromEnv$set;
        @Generated
        private ArgsFromEnvFunction argsFromEnv$value;

        @Generated
        SimpleDelegatorBuilder() {
        }

        @Generated
        public SimpleDelegatorBuilder subschema(@NonNull Subschema subschema) {
            if (subschema == null) {
                throw new NullPointerException("subschema is marked non-null but is null");
            }
            this.subschema = subschema;
            return this;
        }

        @Generated
        public SimpleDelegatorBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        @Generated
        public SimpleDelegatorBuilder argsFromEnv(@NonNull ArgsFromEnvFunction argsFromEnv) {
            if (argsFromEnv == null) {
                throw new NullPointerException("argsFromEnv is marked non-null but is null");
            }
            this.argsFromEnv$value = argsFromEnv;
            this.argsFromEnv$set = true;
            return this;
        }

        @Generated
        public SimpleDelegator build() {
            ArgsFromEnvFunction argsFromEnv$value = this.argsFromEnv$value;
            if (!this.argsFromEnv$set) {
                argsFromEnv$value = SimpleDelegator.$default$argsFromEnv();
            }
            return new SimpleDelegator(this.subschema, this.fieldName, argsFromEnv$value);
        }

        @Generated
        public String toString() {
            return "SimpleDelegator.SimpleDelegatorBuilder(subschema=" + this.subschema + ", fieldName=" + this.fieldName + ", argsFromEnv$value=" + this.argsFromEnv$value + ")";
        }
    }
}

