/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.schema;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.schema.Executor;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

public class RemoteExecutor
implements Executor {
    @NonNull
    private final WebClient webClient;
    @NonNull
    private final URI endpoint;

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionInput input) {
        ParameterizedTypeReference<Map<String, Object>> mapTypeRef = new ParameterizedTypeReference<Map<String, Object>>(){};
        Map<String, Map> body = Map.of("query", input.getQuery(), "variables", input.getVariables());
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.endpoint)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue(body)).retrieve().bodyToMono((ParameterizedTypeReference)mapTypeRef).map(RemoteExecutor::mapToResult).toFuture();
    }

    private static ExecutionResult mapToResult(Map<String, Object> body) {
        return ExecutionResultImpl.newExecutionResult().data(body.get("data")).build();
    }

    @Generated
    RemoteExecutor(@NonNull WebClient webClient, @NonNull URI endpoint) {
        if (webClient == null) {
            throw new NullPointerException("webClient is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        this.webClient = webClient;
        this.endpoint = endpoint;
    }

    @Generated
    public static RemoteExecutorBuilder newExecutor() {
        return new RemoteExecutorBuilder();
    }

    @Generated
    public static class RemoteExecutorBuilder {
        @Generated
        private WebClient webClient;
        @Generated
        private URI endpoint;

        @Generated
        RemoteExecutorBuilder() {
        }

        @Generated
        public RemoteExecutorBuilder webClient(@NonNull WebClient webClient) {
            if (webClient == null) {
                throw new NullPointerException("webClient is marked non-null but is null");
            }
            this.webClient = webClient;
            return this;
        }

        @Generated
        public RemoteExecutorBuilder endpoint(@NonNull URI endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint is marked non-null but is null");
            }
            this.endpoint = endpoint;
            return this;
        }

        @Generated
        public RemoteExecutor build() {
            return new RemoteExecutor(this.webClient, this.endpoint);
        }

        @Generated
        public String toString() {
            return "RemoteExecutor.RemoteExecutorBuilder(webClient=" + this.webClient + ", endpoint=" + this.endpoint + ")";
        }
    }
}

