/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.schema;

import graphql.ExecutionInput;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.language.SDLDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.concurrent.CompletableFuture;
import org.dotwebstack.graphql.orchestrate.schema.Executor;

public class SchemaIntrospector {
    private SchemaIntrospector() {
    }

    public static CompletableFuture<TypeDefinitionRegistry> introspectSchema(Executor executor) {
        return ((CompletableFuture)executor.execute(ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n        isRepeatable\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields(includeDeprecated: true) {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n    isDeprecated\n    deprecationReason\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build()).thenApply(arg_0 -> ((IntrospectionResultToSchema)new IntrospectionResultToSchema()).createSchemaDefinition(arg_0))).thenApply(SchemaIntrospector::buildTypeDefinitionRegistry);
    }

    private static TypeDefinitionRegistry buildTypeDefinitionRegistry(Document document) {
        TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        document.getDefinitions().stream().filter(SDLDefinition.class::isInstance).map(SDLDefinition.class::cast).forEach(arg_0 -> ((TypeDefinitionRegistry)typeDefinitionRegistry).add(arg_0));
        return typeDefinitionRegistry;
    }
}

