/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.transform;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLSchema;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.transform.AbstractTransform;
import org.dotwebstack.graphql.orchestrate.transform.ObjectFieldFilter;
import org.dotwebstack.graphql.orchestrate.transform.SchemaMapping;
import org.dotwebstack.graphql.orchestrate.transform.TransformContext;
import org.dotwebstack.graphql.orchestrate.transform.TransformException;
import org.dotwebstack.graphql.orchestrate.transform.TransformUtils;

public class FilterObjectFields
extends AbstractTransform {
    private final ObjectFieldFilter filter;

    public FilterObjectFields(@NonNull ObjectFieldFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        this.filter = filter;
    }

    @Override
    public GraphQLSchema transformSchema(@NonNull GraphQLSchema originalSchema, @NonNull TransformContext context) {
        if (originalSchema == null) {
            throw new NullPointerException("originalSchema is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return TransformUtils.mapSchema(originalSchema, SchemaMapping.newSchemaMapping().objectType((objectType, traverserContext) -> {
            List fieldDefinitions = objectType.getFieldDefinitions().stream().filter(fieldDefinition -> this.filter.apply(objectType.getName(), fieldDefinition.getName(), (GraphQLFieldDefinition)fieldDefinition)).collect(Collectors.toList());
            if (fieldDefinitions.isEmpty()) {
                throw new TransformException("Object types must contain at least 1 field.");
            }
            return TreeTransformerUtil.changeNode((TraverserContext)traverserContext, (Object)objectType.transform(builder -> builder.replaceFields(fieldDefinitions)));
        }).build());
    }
}

