/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.transform;

import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.SelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.dotwebstack.graphql.orchestrate.Request;
import org.dotwebstack.graphql.orchestrate.Result;
import org.dotwebstack.graphql.orchestrate.transform.AbstractTransform;
import org.dotwebstack.graphql.orchestrate.transform.RequestMapping;
import org.dotwebstack.graphql.orchestrate.transform.SchemaMapping;
import org.dotwebstack.graphql.orchestrate.transform.TransformContext;
import org.dotwebstack.graphql.orchestrate.transform.TransformException;
import org.dotwebstack.graphql.orchestrate.transform.TransformUtils;

public class HoistField
extends AbstractTransform {
    private final String typeName;
    private final String targetFieldName;
    private final List<String> sourceFieldPath;
    private GraphQLSchema transformedSchema;
    private boolean targetFieldList = false;

    public HoistField(String typeName, String targetFieldName, List<String> sourceFieldPath) {
        if (sourceFieldPath.size() <= 1) {
            throw new IllegalArgumentException("Source field path must contain at least 2 fields.");
        }
        this.typeName = typeName;
        this.targetFieldName = targetFieldName;
        this.sourceFieldPath = Collections.unmodifiableList(sourceFieldPath);
    }

    @Override
    public GraphQLSchema transformSchema(@NonNull GraphQLSchema originalSchema, @NonNull TransformContext context) {
        if (originalSchema == null) {
            throw new NullPointerException("originalSchema is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (originalSchema.getObjectType(this.typeName) == null) {
            throw new TransformException(String.format("Object type '%s' not found.", this.typeName));
        }
        SchemaMapping schemaMapping = SchemaMapping.newSchemaMapping().objectType((objectType, traverserContext) -> {
            if (!this.typeName.equals(objectType.getName())) {
                return TraversalControl.CONTINUE;
            }
            GraphQLFieldDefinition sourceField = this.findSourceField((GraphQLObjectType)objectType, this.sourceFieldPath, false);
            GraphQLFieldDefinition hoistedField = sourceField.transform(builder -> builder.name(this.targetFieldName).type(this.wrapListType(sourceField.getType())));
            return TreeTransformerUtil.changeNode((TraverserContext)traverserContext, (Object)objectType.transform(builder -> builder.field(hoistedField)));
        }).build();
        this.transformedSchema = TransformUtils.mapSchema(originalSchema, schemaMapping);
        return this.transformedSchema;
    }

    private GraphQLOutputType wrapListType(GraphQLOutputType type) {
        return this.targetFieldList ? GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)type)) : type;
    }

    private GraphQLFieldDefinition findSourceField(GraphQLObjectType objectType, List<String> fieldPath, boolean isNullable) {
        GraphQLUnmodifiedType fieldType;
        String fieldName = fieldPath.get(0);
        int fieldPathSize = fieldPath.size();
        GraphQLFieldDefinition field = Optional.ofNullable(objectType.getFieldDefinition(fieldName)).orElseThrow(() -> new TransformException(String.format("Object field '%s' not found.", fieldName)));
        if (GraphQLTypeUtil.isNullable((GraphQLType)field.getType())) {
            isNullable = true;
        }
        if (fieldPathSize == 1) {
            if (isNullable) {
                return field.transform(builder -> builder.type((GraphQLOutputType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)field.getType())).build());
            }
            return field;
        }
        if (GraphQLTypeUtil.unwrapNonNull((GraphQLType)field.getType()) instanceof GraphQLList) {
            if (this.targetFieldList) {
                throw new TransformException("Source field path contains more than one list field.");
            }
            this.targetFieldList = true;
        }
        if (!((fieldType = GraphQLTypeUtil.unwrapAll((GraphQLType)field.getType())) instanceof GraphQLObjectType)) {
            throw new TransformException("Non-leaf path segments must represent object types.");
        }
        return this.findSourceField((GraphQLObjectType)fieldType, fieldPath.subList(1, fieldPathSize), isNullable);
    }

    @Override
    public CompletableFuture<Result> transform(@NonNull Request originalRequest, @NonNull Function<Request, CompletableFuture<Result>> next) {
        if (originalRequest == null) {
            throw new NullPointerException("originalRequest is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        ArrayList hoistedFields = new ArrayList();
        RequestMapping mapping = RequestMapping.newRequestMapping().field(environment -> {
            if (!this.isFieldMatching((QueryVisitorFieldEnvironment)environment)) {
                return TraversalControl.CONTINUE;
            }
            String targetKey = environment.getField().getResultKey();
            hoistedFields.add(new HoistedField(TransformUtils.getResultPath((TraverserContext<Node>)environment.getTraverserContext()), targetKey));
            return this.hoistField((QueryVisitorFieldEnvironment)environment);
        }).build();
        return next.apply(TransformUtils.mapRequest(originalRequest, this.transformedSchema, mapping)).thenApply(result -> this.dehoistFields((Result)result, Collections.unmodifiableList(hoistedFields)));
    }

    private boolean isFieldMatching(QueryVisitorFieldEnvironment environment) {
        GraphQLFieldsContainer fieldsContainer = environment.getFieldsContainer();
        GraphQLFieldDefinition fieldDefinition = environment.getFieldDefinition();
        return this.typeName.equals(fieldsContainer.getName()) && this.targetFieldName.equals(fieldDefinition.getName());
    }

    private TraversalControl hoistField(QueryVisitorFieldEnvironment environment) {
        QueryVisitorFieldEnvironment parentEnvironment = environment.getParentEnvironment();
        Field parentField = parentEnvironment.getField();
        return TreeTransformerUtil.changeNode((TraverserContext)parentEnvironment.getTraverserContext(), (Object)parentField.transform(builder -> builder.selectionSet(this.transformSelectionSet(parentField.getSelectionSet()))));
    }

    private SelectionSet transformSelectionSet(SelectionSet selectionSet) {
        SelectionSet hoistedSelectionSet = TransformUtils.getFieldSelectionSet(selectionSet, this.targetFieldName);
        return TransformUtils.includeFieldPath(TransformUtils.excludeField(selectionSet, this.targetFieldName), hoistedSelectionSet, this.sourceFieldPath);
    }

    private Result dehoistFields(Result result, List<HoistedField> hoistedFields) {
        Map data = (Map)hoistedFields.stream().reduce(result.getData(), this::dehoistField, TransformUtils::noopCombiner);
        return result.transform(builder -> builder.data(data));
    }

    private Object dehoistField(Object data, HoistedField hoistedField) {
        return TransformUtils.mapTransform(data, hoistedField.getBasePath(), fieldContainer -> TransformUtils.putMapValue(fieldContainer, hoistedField.getTargetKey(), TransformUtils.getFieldValue(fieldContainer, this.sourceFieldPath)));
    }

    private static class HoistedField {
        private final List<String> basePath;
        private final String targetKey;

        public HoistedField(List<String> basePath, String targetKey) {
            this.basePath = basePath;
            this.targetKey = targetKey;
        }

        @Generated
        public List<String> getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getTargetKey() {
            return this.targetKey;
        }
    }
}

